/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.TileObject;

public final class BlobStoreListenerList {
    private List<BlobStoreListener> listeners = new CopyOnWriteArrayList<BlobStoreListener>();

    public Iterable<BlobStoreListener> getListeners() {
        return new ArrayList<BlobStoreListener>(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public synchronized void addListener(BlobStoreListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean removeListener(BlobStoreListener listener) {
        return this.listeners.remove(listener);
    }

    public void sendLayerDeleted(String layerName) {
        this.listeners.forEach(listener -> listener.layerDeleted(layerName));
    }

    public void sendLayerRenamed(String oldLayerName, String newLayerName) {
        this.listeners.forEach(listener -> listener.layerRenamed(oldLayerName, newLayerName));
    }

    public void sendGridSubsetDeleted(String layerName, String gridSetId) {
        this.listeners.forEach(listener -> listener.gridSubsetDeleted(layerName, gridSetId));
    }

    public void sendParametersDeleted(String layerName, String parametersId) {
        this.listeners.forEach(listener -> listener.parametersDeleted(layerName, parametersId));
    }

    public void sendTileDeleted(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long length) {
        this.listeners.forEach(listener -> listener.tileDeleted(layerName, gridSetId, blobFormat, parametersId, x, y, z, length));
    }

    public void sendTileDeleted(TileObject stObj) {
        long[] xyz = stObj.getXYZ();
        String layerName = stObj.getLayerName();
        String gridSetId = stObj.getGridSetId();
        String blobFormat = stObj.getBlobFormat();
        String paramsId = stObj.getParametersId();
        int blobSize = stObj.getBlobSize();
        this.sendTileDeleted(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize);
    }

    public void sendTileStored(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long length) {
        this.listeners.forEach(listener -> listener.tileStored(layerName, gridSetId, blobFormat, parametersId, x, y, z, length));
    }

    public void sendTileStored(TileObject stObj) {
        long[] xyz = stObj.getXYZ();
        String layerName = stObj.getLayerName();
        String gridSetId = stObj.getGridSetId();
        String blobFormat = stObj.getBlobFormat();
        String paramsId = stObj.getParametersId();
        int blobSize = stObj.getBlobSize();
        this.sendTileStored(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize);
    }

    public void sendTileUpdated(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize, long oldSize) {
        this.listeners.forEach(listener -> listener.tileUpdated(layerName, gridSetId, blobFormat, parametersId, x, y, z, blobSize, oldSize));
    }

    public void sendTileUpdated(TileObject stObj, long oldSize) {
        long[] xyz = stObj.getXYZ();
        String layerName = stObj.getLayerName();
        String gridSetId = stObj.getGridSetId();
        String blobFormat = stObj.getBlobFormat();
        String paramsId = stObj.getParametersId();
        int blobSize = stObj.getBlobSize();
        this.sendTileUpdated(layerName, gridSetId, blobFormat, paramsId, xyz[0], xyz[1], (int)xyz[2], blobSize, oldSize);
    }
}

