/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class TextMime
extends MimeType {
    public static final TextMime txt = new TextMime("text/plain", "txt", "txt", "text/plain", true);
    public static final TextMime txtHtml = new TextMime("text/html", "txt.html", "html", "text/html", true);
    public static final TextMime txtMapml = new TextMime("text/mapml", "mapml", "mapml", "text/mapml", true);
    public static final TextMime txtXml = new TextMime("text/xml", "xml", "xml", "text/xml", true);
    public static final TextMime txtCss = new TextMime("text/css", "css", "css", "text/css", true);
    public static final TextMime txtJs = new TextMime("text/javascript", "js", "javascript", "text/javascript", true);

    private TextMime(String mimeType, String fileExtension, String internalName, String format, boolean noop) {
        super(mimeType, fileExtension, internalName, format, false);
    }

    protected static TextMime checkForFormat(String formatStr) throws MimeException {
        if (formatStr.toLowerCase().startsWith("text")) {
            if (formatStr.equalsIgnoreCase("text/plain")) {
                return txt;
            }
            if (formatStr.startsWith("text/html")) {
                return txtHtml;
            }
            if (formatStr.startsWith("text/mapml")) {
                return txtMapml;
            }
            if (formatStr.startsWith("text/xml")) {
                return txtXml;
            }
            if (formatStr.startsWith("text/css")) {
                return txtCss;
            }
            if (formatStr.startsWith("text/javascript")) {
                return txtJs;
            }
        }
        return null;
    }

    protected static TextMime checkForExtension(String fileExtension) throws MimeException {
        if (fileExtension.equalsIgnoreCase("txt")) {
            return txt;
        }
        if (fileExtension.equalsIgnoreCase("txt.html")) {
            return txtHtml;
        }
        if (fileExtension.equalsIgnoreCase("html")) {
            return txtHtml;
        }
        if (fileExtension.equalsIgnoreCase("mapml")) {
            return txtMapml;
        }
        if (fileExtension.equalsIgnoreCase("xml")) {
            return txtXml;
        }
        if (fileExtension.equalsIgnoreCase("css")) {
            return txtCss;
        }
        if (fileExtension.equalsIgnoreCase("js")) {
            return txtJs;
        }
        return null;
    }
}

