/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ConfigurationAggregator;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.grid.GridSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GridSetBroker
implements ConfigurationAggregator<GridSetConfiguration>,
ApplicationContextAware,
InitializingBean {
    private static Logger log = Logging.getLogger((String)GridSetBroker.class.getName());
    private List<GridSetConfiguration> configurations;
    private volatile DefaultGridsets defaults;
    private ApplicationContext applicationContext;

    public GridSetBroker() {
    }

    public GridSetBroker(List<GridSetConfiguration> configurations) {
        this.configurations = configurations;
        this.defaults = configurations.stream().filter(DefaultGridsets.class::isInstance).findFirst().map(DefaultGridsets.class::cast).get();
    }

    public void afterPropertiesSet() {
        this.getConfigurations();
    }

    @Nullable
    public GridSet get(String gridSetId) {
        return this.getGridSet(gridSetId).orElse(null);
    }

    protected Optional<GridSet> getGridSet(String name) {
        for (GridSetConfiguration c : this.getConfigurations()) {
            Optional<GridSet> gridSet = c.getGridSet(name);
            if (!gridSet.isPresent()) continue;
            GridSet set = gridSet.get();
            return Optional.of(set);
        }
        return Optional.empty();
    }

    public Set<String> getEmbeddedNames() {
        return this.defaults.getGridSetNames();
    }

    public Set<String> getNames() {
        return this.getGridSetNames();
    }

    public Set<String> getGridSetNames() {
        return this.getConfigurations().stream().map(GridSetConfiguration::getGridSetNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Collection<GridSet> getGridSets() {
        return this.getConfigurations().stream().map(GridSetConfiguration::getGridSets).flatMap(Collection::stream).collect(Collectors.toMap(GridSet::getName, g -> g, (g1, g2) -> g1, HashMap::new)).values();
    }

    public synchronized void put(GridSet gridSet) {
        this.remove(gridSet.getName());
        this.addGridSet(gridSet);
    }

    public void addGridSet(GridSet gridSet) {
        log.fine("Adding " + gridSet.getName());
        this.getConfigurations().stream().filter(c -> c.canSave(gridSet)).findFirst().orElseThrow(() -> new UnsupportedOperationException("No Configuration is able to save gridset " + gridSet.getName())).addGridSet(gridSet);
    }

    public synchronized GridSet remove(String gridSetName) {
        return this.getGridSet(gridSetName).map(g -> {
            this.removeGridSet(gridSetName);
            return g;
        }).orElse(null);
    }

    public synchronized void removeGridSet(String gridSetName) {
        this.getConfigurations().stream().filter(c -> c.getGridSet(gridSetName).isPresent()).forEach(c -> c.removeGridSet(gridSetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultGridsets getDefaults() {
        if (this.defaults == null) {
            GridSetBroker gridSetBroker = this;
            synchronized (gridSetBroker) {
                if (this.defaults == null) {
                    try {
                        Iterator<DefaultGridsets> it = this.getConfigurations((Class)DefaultGridsets.class).iterator();
                        this.defaults = it.next();
                        if (it.hasNext()) {
                            log.warning("GridSetBroker has more than one DefaultGridSets configuration");
                        }
                    }
                    catch (NoSuchElementException ex) {
                        throw new IllegalStateException("GridSetBroker has no DefaultGridsets configuration", ex);
                    }
                }
            }
        }
        return this.defaults;
    }

    public GridSet getWorldEpsg4326() {
        GridSet internalDefault4326GridSet = this.getDefaults().worldEpsg4326();
        String internalDefault4326Name = internalDefault4326GridSet.getName();
        Optional<GridSet> gridSet = this.getGridSet(internalDefault4326Name);
        if (gridSet.isPresent()) {
            return gridSet.get();
        }
        return internalDefault4326GridSet;
    }

    public GridSet getWorldEpsg3857() {
        GridSet internalDefault3857GridSet = this.getDefaults().worldEpsg3857();
        String internalDefault3857Name = internalDefault3857GridSet.getName();
        Optional<GridSet> gridSet = this.getGridSet(internalDefault3857Name);
        if (gridSet.isPresent()) {
            return gridSet.get();
        }
        return internalDefault3857GridSet;
    }

    @Override
    public <GSC extends GridSetConfiguration> List<? extends GSC> getConfigurations(Class<GSC> type) {
        return this.getConfigurations().stream().filter(type::isInstance).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<GridSetConfiguration> getConfigurations() {
        if (this.configurations == null || this.configurations.size() == 1 && this.configurations.get(0) instanceof DefaultGridsets) {
            GridSetBroker gridSetBroker = this;
            synchronized (gridSetBroker) {
                if (this.configurations == null || this.configurations.size() == 1 && this.configurations.get(0).equals(this.defaults)) {
                    if (Objects.nonNull(this.applicationContext)) {
                        this.configurations = GeoWebCacheExtensions.configurations(GridSetConfiguration.class, this.applicationContext);
                    } else {
                        log.fine("GridSetBroker.initialize() called without having set application context");
                        this.configurations = GeoWebCacheExtensions.configurations(GridSetConfiguration.class);
                    }
                    if (this.defaults != null && !this.configurations.contains(this.defaults)) {
                        this.configurations.add(this.defaults);
                    }
                }
            }
        }
        return this.configurations;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

