/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.CaseNormalizingParameterFilter;
import org.geowebcache.filter.parameters.ParameterException;

@ParametersAreNonnullByDefault
@XStreamAlias(value="regexParameterFilter")
public class RegexParameterFilter
extends CaseNormalizingParameterFilter {
    private static final long serialVersionUID = -1496940509350980799L;
    public static final String DEFAULT_EXPRESSION = "";
    private String regex = "";
    private transient Pattern pat = RegexParameterFilter.compile(this.regex, this.getNormalize().getCase());

    public synchronized Matcher getMatcher(String value) {
        return this.pat.matcher(value);
    }

    static Pattern compile(String regex, CaseNormalizer.Case c) {
        int flags = 0;
        if (c != CaseNormalizer.Case.NONE) {
            flags += 2;
            flags += 64;
        }
        return Pattern.compile(regex, flags);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        Preconditions.checkNotNull((Object)this.regex);
        this.pat = RegexParameterFilter.compile(this.regex, this.getNormalize().getCase());
        return this;
    }

    @Override
    public String apply(String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return this.getDefaultValue();
        }
        if (this.getMatcher(str).matches()) {
            return this.getNormalize().apply(str);
        }
        throw new ParameterException(str + " violates filter for parameter " + this.getKey());
    }

    @Override
    @Nullable
    public List<String> getLegalValues() {
        return null;
    }

    @Override
    public boolean applies(@Nullable String parameterValue) {
        return this.getMatcher(parameterValue).matches();
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(@Nullable String regex) {
        if (regex == null) {
            regex = DEFAULT_EXPRESSION;
        }
        this.regex = regex;
        this.pat = RegexParameterFilter.compile(this.regex, this.getNormalize().getCase());
    }

    @Override
    public void setNormalize(CaseNormalizer normalize) {
        super.setNormalize(normalize);
        this.pat = RegexParameterFilter.compile(this.regex, this.getNormalize().getCase());
    }

    @Override
    public RegexParameterFilter clone() {
        RegexParameterFilter clone = (RegexParameterFilter)super.clone();
        if (this.normalize != null) {
            clone.setNormalize(this.normalize.clone());
        }
        return clone;
    }

    @Override
    public List<String> getValues() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexParameterFilter other = (RegexParameterFilter)obj;
        return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
    }

    @Override
    public String toString() {
        return "RegexParameterFilter [regex=" + this.regex + ", " + super.toString() + "]";
    }
}

