/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.conveyor;

import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;

public class ConveyorTile
extends Conveyor
implements TileResponseReceiver {
    private static Logger log = Logging.getLogger((String)ConveyorTile.class.getName());
    protected String gridSetId = null;
    protected GridSubset gridSubset = null;
    protected TileLayer tileLayer = null;
    TileObject stObj = null;
    private Map<String, String[]> fullParameters;
    private Map<String, String> filteringParameters;
    private boolean isMetaTileCacheOnly;

    public ConveyorTile(StorageBroker sb, String layerId, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(layerId, sb, servletReq, servletResp);
    }

    public ConveyorTile(StorageBroker sb, String layerId, String gridSetId, long[] tileIndex, MimeType mimeType, Map<String, String[]> fullParameters, Map<String, String> filteringParameters, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        this(sb, layerId, gridSetId, tileIndex, mimeType, filteringParameters, servletReq, servletResp);
        this.fullParameters = fullParameters;
    }

    public ConveyorTile(StorageBroker sb, String layerId, String gridSetId, long[] tileIndex, MimeType mimeType, Map<String, String> filteringParameters, HttpServletRequest servletReq, HttpServletResponse servletResp) {
        super(layerId, sb, servletReq, servletResp);
        this.gridSetId = gridSetId;
        long[] idx = new long[3];
        if (tileIndex != null) {
            idx[0] = tileIndex[0];
            idx[1] = tileIndex[1];
            idx[2] = tileIndex[2];
        }
        this.mimeType = mimeType;
        this.filteringParameters = filteringParameters;
        this.stObj = TileObject.createQueryTileObject(layerId, idx, gridSetId, mimeType.getFormat(), filteringParameters);
    }

    public Map<String, String> getFilteringParameters() {
        if (this.filteringParameters == null) {
            return Collections.emptyMap();
        }
        return this.filteringParameters;
    }

    public Map<String, String[]> getRequestParameters() {
        if (this.fullParameters == null) {
            return Collections.emptyMap();
        }
        return this.fullParameters;
    }

    public TileLayer getLayer() {
        return this.tileLayer;
    }

    public void setTileLayer(TileLayer layer) {
        this.tileLayer = layer;
    }

    public TileLayer getTileLayer() {
        return this.tileLayer;
    }

    public long getTSCreated() {
        return this.stObj.getCreated();
    }

    @Override
    public int getStatus() {
        return (int)this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMsg = errorMessage;
    }

    public Map<String, String> getParameters() {
        return this.stObj.getParameters();
    }

    public long[] getTileIndex() {
        return this.stObj.getXYZ();
    }

    public synchronized GridSubset getGridSubset() {
        if (this.gridSubset == null && this.gridSetId != null) {
            this.gridSubset = this.tileLayer.getGridSubset(this.gridSetId);
        }
        return this.gridSubset;
    }

    public String getGridSetId() {
        return this.gridSetId;
    }

    public void setGridSetId(String gridSetId) {
        this.gridSetId = gridSetId;
    }

    public Resource getBlob() {
        return this.stObj.getBlob();
    }

    public void setBlob(Resource payload) {
        this.stObj.setBlob(payload);
    }

    public TileObject getStorageObject() {
        return this.stObj;
    }

    public boolean persist() throws GeoWebCacheException {
        try {
            return this.storageBroker.put(this.stObj);
        }
        catch (StorageException e) {
            throw new GeoWebCacheException(e);
        }
    }

    public boolean retrieve(long maxAge) throws GeoWebCacheException {
        try {
            if (this.isMetaTileCacheOnly) {
                boolean cached = this.storageBroker.getTransient(this.stObj);
                this.setCacheResult(cached ? Conveyor.CacheResult.HIT : Conveyor.CacheResult.MISS);
                return cached;
            }
            boolean ret = this.storageBroker.get(this.stObj);
            if (ret && maxAge > 0L && this.stObj.getCreated() + maxAge < System.currentTimeMillis()) {
                ret = false;
            }
            if (ret) {
                this.setCacheResult(Conveyor.CacheResult.HIT);
            } else {
                this.setCacheResult(Conveyor.CacheResult.MISS);
            }
            return ret;
        }
        catch (StorageException se) {
            log.warning(se.getMessage());
            return false;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ConveyorTile[");
        long[] idx = this.stObj.getXYZ();
        if (this.getLayerId() != null) {
            str.append(this.getLayerId()).append(" ");
        }
        if (this.gridSetId != null) {
            str.append(this.gridSetId).append(" ");
        }
        if (idx != null && idx.length == 3) {
            str.append("{" + idx[0] + "," + idx[1] + "," + idx[2] + "} ");
        }
        if (this.mimeType != null) {
            str.append(this.mimeType.getFormat());
        }
        str.append(']');
        return str.toString();
    }

    public String getParametersId() {
        return this.stObj.getParametersId();
    }

    public void setMetaTileCacheOnly(boolean b) {
        this.isMetaTileCacheOnly = b;
    }

    public boolean isMetaTileCacheOnly() {
        return this.isMetaTileCacheOnly;
    }
}

