/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.text.MessageFormat;
import java.util.Collection;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.ProcessException;
import org.geotools.referencing.CRS;

public class BaseCoverageAlgebraProcess {
    static final String MISMATCHING_ENVELOPE_MESSAGE = "coverageA and coverageB should share the same Envelope";
    static final String MISMATCHING_GRID_MESSAGE = "coverageA and coverageB should have the same gridRange";
    static final String MISMATCHING_CRS_MESSAGE = "coverageA and coverageB should share the same CoordinateReferenceSystem";

    private BaseCoverageAlgebraProcess() {
    }

    public static void checkCompatibleCoverages(GridCoverage2D coverageA, GridCoverage2D coverageB) throws ProcessException {
        Bounds envB;
        Bounds envA;
        CoordinateReferenceSystem crsB;
        if (coverageA == null || coverageB == null) {
            String coveragesNull = coverageA == null ? (coverageB == null ? "coverageA and coverageB" : "coverageA") : "coverageB";
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", coveragesNull));
        }
        CoordinateReferenceSystem crsA = coverageA.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)crsA, (Object)(crsB = coverageB.getCoordinateReferenceSystem()))) {
            MathTransform mathTransform = null;
            try {
                mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)crsA, (CoordinateReferenceSystem)crsB);
            }
            catch (FactoryException e) {
                throw new ProcessException("Exceptions occurred while looking for a mathTransform between the 2 coverage's CRSs", e);
            }
            if (mathTransform != null && !mathTransform.isIdentity()) {
                throw new ProcessException(MISMATCHING_CRS_MESSAGE);
            }
        }
        if (!(envA = coverageA.getEnvelope()).equals(envB = coverageB.getEnvelope())) {
            throw new ProcessException(MISMATCHING_ENVELOPE_MESSAGE);
        }
        GridEnvelope gridRangeA = coverageA.getGridGeometry().getGridRange();
        GridEnvelope gridRangeB = coverageA.getGridGeometry().getGridRange();
        if (gridRangeA.getSpan(0) != gridRangeB.getSpan(0) || gridRangeA.getSpan(1) != gridRangeB.getSpan(1)) {
            throw new ProcessException(MISMATCHING_GRID_MESSAGE);
        }
    }

    public static void checkCompatibleCoveragesForMerge(Collection<GridCoverage2D> coverages) throws ProcessException {
        if (coverages == null || coverages.isEmpty()) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "Input coverage List"));
        }
        CoordinateReferenceSystem crs = null;
        for (GridCoverage2D coverage : coverages) {
            if (crs == null) {
                crs = coverage.getCoordinateReferenceSystem();
                continue;
            }
            CoordinateReferenceSystem crs1 = coverage.getCoordinateReferenceSystem();
            BaseCoverageAlgebraProcess.checkCompatibleCRS(crs, crs1);
        }
    }

    public static void checkCompatibleCRS(CoordinateReferenceSystem crsA, CoordinateReferenceSystem crsB) {
        if (!CRS.equalsIgnoreMetadata((Object)crsA, (Object)crsB)) {
            MathTransform mathTransform = null;
            try {
                mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)crsA, (CoordinateReferenceSystem)crsB);
            }
            catch (FactoryException e) {
                throw new ProcessException("Exceptions occurred while looking for a mathTransform between the coverage's CRSs", e);
            }
            if (mathTransform != null && !mathTransform.isIdentity()) {
                throw new ProcessException(MISMATCHING_CRS_MESSAGE);
            }
        }
    }
}

