/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.OutputStrategyFactory;
import org.geoserver.ows.ServiceStrategy;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.servlets.PartialBufferStrategy2;

public class ServiceStrategyFactory
implements OutputStrategyFactory,
ApplicationContextAware {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.servlets");
    GeoServer geoServer;
    ApplicationContext context;
    String serviceStrategy;
    int partialBufferSize = 50;

    public ServiceStrategyFactory(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setServiceStrategy(String serviceStrategy) {
        this.serviceStrategy = serviceStrategy;
    }

    public void setPartialBufferSize(int partialBufferSize) {
        this.partialBufferSize = partialBufferSize;
    }

    public ServletContext getServletContext() {
        return ((WebApplicationContext)this.context).getServletContext();
    }

    public ServiceStrategy createOutputStrategy(HttpServletResponse response) {
        ServiceStrategy theStrategy = null;
        if (this.serviceStrategy == null) {
            this.serviceStrategy = GeoServerExtensions.getProperty((String)"serviceStrategy");
        }
        if (this.serviceStrategy != null) {
            theStrategy = (ServiceStrategy)this.context.getBean(this.serviceStrategy);
        }
        if (theStrategy == null) {
            theStrategy = (ServiceStrategy)this.context.getBean("PARTIAL-BUFFER2");
        }
        try {
            theStrategy = (ServiceStrategy)theStrategy.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Programming error found, service strategies should be cloneable, " + e, e);
            throw new RuntimeException("Found a strategy that does not support cloning...", e);
        }
        if (theStrategy instanceof PartialBufferStrategy2) {
            String size;
            if (this.partialBufferSize == 0 && (size = this.getServletContext().getInitParameter("PARTIAL_BUFFER_STRATEGY_SIZE")) != null) {
                try {
                    this.partialBufferSize = Integer.parseInt(size);
                    if (this.partialBufferSize <= 0) {
                        LOGGER.warning("Invalid partial buffer size, defaulting to 50 (was " + this.partialBufferSize + ")");
                        this.partialBufferSize = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid partial buffer size, defaulting to 50 (was " + this.partialBufferSize + ")");
                    this.partialBufferSize = 0;
                }
            }
            ((PartialBufferStrategy2)theStrategy).setBufferSize(this.partialBufferSize);
        }
        return theStrategy;
    }
}

