/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.CSPRule;
import org.geoserver.security.csp.CSPUtils;
import org.geotools.util.logging.Logging;

public class CSPPolicy
implements Serializable {
    private static final long serialVersionUID = -6131742124949554000L;
    private static final Logger LOGGER = Logging.getLogger(CSPPolicy.class);
    private static final String DEFAULT_NAME = null;
    private static final String DEFAULT_DESCRIPTION = "";
    private static final Boolean DEFAULT_ENABLED = true;
    private String name;
    private String description;
    private Boolean enabled;
    private List<CSPRule> rules;

    public CSPPolicy() {
        this(DEFAULT_NAME, DEFAULT_DESCRIPTION, DEFAULT_ENABLED, new ArrayList<CSPRule>());
    }

    public CSPPolicy(String name, String description, boolean enabled, List<CSPRule> rules) {
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.rules = rules;
    }

    public CSPPolicy(CSPPolicy other) {
        this(other.getName(), other.getDescription(), other.isEnabled(), other.getRules().stream().map(CSPRule::new).collect(Collectors.toList()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<CSPRule> getRules() {
        return this.rules;
    }

    public void setRules(List<CSPRule> rules) {
        this.rules = rules;
    }

    public String getDirectives(CSPHttpRequestWrapper request) {
        if (this.enabled.booleanValue()) {
            for (int i = 0; i < this.rules.size(); ++i) {
                CSPRule rule = this.rules.get(i);
                if (!rule.test(request)) continue;
                String directives = null;
                for (int j = i; j >= 0 && directives == null; --j) {
                    directives = this.rules.get(j).getDirectives();
                    directives = Strings.emptyToNull((String)CSPUtils.trimWhitespace(directives));
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Matched " + rule.getName() + ": " + directives);
                }
                if (directives == null || "NONE".equalsIgnoreCase(directives)) {
                    return null;
                }
                return CSPUtils.cleanDirectives(directives);
            }
        }
        return null;
    }

    public CSPRule getRuleByName(String name) {
        return this.rules.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CSPPolicy) {
            CSPPolicy other = (CSPPolicy)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.rules, other.rules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.enabled, this.rules);
    }

    private Object readResolve() {
        Preconditions.checkNotNull((Object)this.name, (Object)"The policy name can not be null");
        this.description = (String)MoreObjects.firstNonNull((Object)this.description, (Object)DEFAULT_DESCRIPTION);
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)this.enabled, (Object)DEFAULT_ENABLED);
        this.rules = (List)MoreObjects.firstNonNull(this.rules, new ArrayList());
        Preconditions.checkArgument((this.rules.stream().map(CSPRule::getName).distinct().count() == (long)this.rules.size() ? 1 : 0) != 0, (Object)"Rule names must be unique with a policy");
        return this;
    }
}

