/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.geoserver.security.csp.CSPConfiguration;
import org.geotools.util.logging.Logging;

public class CSPHttpResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = Logging.getLogger(CSPHttpResponseWrapper.class);
    private final CSPConfiguration config;

    public CSPHttpResponseWrapper(HttpServletResponse response, CSPConfiguration config) {
        super(response);
        this.config = config;
    }

    public void setHeader(String name, String value) {
        if ("Content-Security-Policy".equalsIgnoreCase(name) || "Content-Security-Policy-Report-Only".equalsIgnoreCase(name)) {
            this.setContentSecurityPolicy(name, value);
        } else {
            super.setHeader(name, value);
        }
    }

    private void setContentSecurityPolicy(String newName, String newValue) {
        if (!this.config.isEnabled()) {
            if (this.config.isAllowOverride()) {
                super.setHeader(newName, newValue);
            }
            return;
        }
        String oldName = this.config.isReportOnly() ? "Content-Security-Policy-Report-Only" : "Content-Security-Policy";
        String oldValue = this.getHeader(oldName);
        if (this.config.isAllowOverride()) {
            if (oldValue != null && !newName.equalsIgnoreCase(oldName)) {
                super.setHeader(oldName, null);
            }
            String name = "Content-Security-Policy".equalsIgnoreCase(newName) ? "Content-Security-Policy" : "Content-Security-Policy-Report-Only";
            LOGGER.fine(() -> "Overriding header:\n Old" + oldName + ": " + oldValue + "\n New" + name + ": " + newValue);
            super.setHeader(name, newValue);
        } else {
            String merged = CSPHttpResponseWrapper.getMergedHeader(oldValue, newValue);
            LOGGER.fine(() -> "Merging " + oldName + " header:\n Old: " + oldValue + "\n New: " + newValue + "\n Merged: " + merged);
            super.setHeader(oldName, merged);
        }
    }

    private static String getMergedDirective(String value, String directive) {
        int index = directive.indexOf(32);
        String name = index < 0 ? directive : directive.substring(0, index);
        return !name.contains("-src") && !value.contains(name) ? directive : null;
    }

    private static String getMergedHeader(String oldValue, String newValue) {
        String toMerge;
        if (oldValue != null && !(toMerge = Arrays.stream(oldValue.split(",")).map(s -> s.split(";")).flatMap(Arrays::stream).map(String::trim).map(s -> CSPHttpResponseWrapper.getMergedDirective(newValue, s)).filter(Objects::nonNull).collect(Collectors.joining("; "))).isEmpty()) {
            return newValue + (newValue.endsWith(";") ? "" : ";") + ", " + toMerge + ";";
        }
        return newValue;
    }
}

