/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.springframework.security.core.Authentication;

public class InMemorySecurityFilter
extends InternalVolatileFunction {
    ResourceAccessManager resourceAccesssManager;
    Authentication user;

    public static Filter buildUserAccessFilter(ResourceAccessManager resourceAccesssManager, Authentication user) {
        InMemorySecurityFilter visible = new InMemorySecurityFilter(resourceAccesssManager, user);
        FilterFactory factory = Predicates.factory;
        PropertyIsEqualTo filter = factory.equals((Expression)factory.literal((Object)Boolean.TRUE), (Expression)visible);
        return filter;
    }

    public InMemorySecurityFilter(ResourceAccessManager resourceAccesssManager, Authentication user) {
        this.resourceAccesssManager = resourceAccesssManager;
        this.user = user;
    }

    private Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    private SecureCatalogImpl getSecurityWrapper() {
        return (SecureCatalogImpl)GeoServerExtensions.bean(SecureCatalogImpl.class);
    }

    public Boolean evaluate(Object object) {
        CatalogInfo info = (CatalogInfo)object;
        if (info instanceof NamespaceInfo) {
            info = this.getCatalog().getWorkspaceByName(((NamespaceInfo)info).getPrefix());
        }
        if (info == null) {
            return false;
        }
        WrapperPolicy policy = this.getSecurityWrapper().buildWrapperPolicy(this.resourceAccesssManager, this.user, info, SecureCatalogImpl.MixedModeBehavior.HIDE);
        AccessLevel accessLevel = policy.getAccessLevel();
        boolean visible = !AccessLevel.HIDDEN.equals((Object)accessLevel);
        return visible;
    }
}

