/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.FirewalledRequest;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;

public class GeoServerHttpFirewall
implements HttpFirewall {
    public static final String USE_STRICT_FIREWALL = "GEOSERVER_USE_STRICT_FIREWALL";
    private final DefaultHttpFirewall defaultFirewall = new DefaultHttpFirewall();
    private final StrictHttpFirewall strictFirewall = new StrictHttpFirewall();

    public FirewalledRequest getFirewalledRequest(HttpServletRequest request) {
        if (!"false".equalsIgnoreCase(GeoServerExtensions.getProperty((String)USE_STRICT_FIREWALL))) {
            this.strictFirewall.getFirewalledRequest((HttpServletRequest)new NormalizedHttpServletRequest(request));
        }
        return this.defaultFirewall.getFirewalledRequest(request);
    }

    public HttpServletResponse getFirewalledResponse(HttpServletResponse response) {
        return this.defaultFirewall.getFirewalledResponse(response);
    }

    private static class NormalizedHttpServletRequest
    extends HttpServletRequestWrapper {
        private static final Pattern FORWARD_SLASHES = Pattern.compile("//+");

        private NormalizedHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        private static String normalizeSlashes(String path) {
            return path != null ? FORWARD_SLASHES.matcher(path).replaceAll("/") : null;
        }

        public String getContextPath() {
            return NormalizedHttpServletRequest.normalizeSlashes(super.getContextPath());
        }

        public String getPathInfo() {
            return NormalizedHttpServletRequest.normalizeSlashes(super.getPathInfo());
        }

        public String getRequestURI() {
            return NormalizedHttpServletRequest.normalizeSlashes(super.getRequestURI());
        }

        public String getServletPath() {
            return NormalizedHttpServletRequest.normalizeSlashes(super.getServletPath());
        }
    }
}

