/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.geoserver.logging.LoggingUtilsDelegate;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.vfny.geoserver.global.ConfigurationException;

public class LoggingUtils {
    public static final String RELINQUISH_LOG4J_CONTROL = "RELINQUISH_LOG4J_CONTROL";
    static boolean relinquishLog4jControl = false;
    public static final String UPDATE_BUILT_IN_LOGGING_PROFILES = "UPDATE_BUILT_IN_LOGGING_PROFILES";
    static boolean updateBuiltInLoggingProfiles = false;
    public static final String GT2_LOGGING_REDIRECTION = "GT2_LOGGING_REDIRECTION";
    public static final String GEOSERVER_LOG_LOCATION = "GEOSERVER_LOG_LOCATION";
    public static final String[] STANDARD_LOGGING_CONFIGURATIONS = new String[]{"DEFAULT_LOGGING", "GEOSERVER_DEVELOPER_LOGGING", "GEOTOOLS_DEVELOPER_LOGGING", "PRODUCTION_LOGGING", "QUIET_LOGGING", "TEST_LOGGING", "VERBOSE_LOGGING"};

    public static void configureGeoServerLogging(String level) {
    }

    public static void configureGeoServerLogging(GeoServerResourceLoader loader, Resource configResource, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        if (!relinquishLog4jControl) {
            LoggingUtilsDelegate.configureGeoServerLogging(loader, configResource, suppressStdOutLogging, suppressFileLogging, logFileName);
        }
    }

    public static void initLogging(GeoServerResourceLoader resourceLoader, String configFileName, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws Exception {
        if (!relinquishLog4jControl) {
            LoggingUtilsDelegate.initLogging(resourceLoader, configFileName, suppressStdOutLogging, suppressFileLogging, logFileName);
        }
    }

    public static void checkBuiltInLoggingConfiguration(GeoServerResourceLoader resourceLoader, String logConfigFile) {
        if (!relinquishLog4jControl) {
            LoggingUtilsDelegate.checkBuiltInLoggingConfiguration(resourceLoader, logConfigFile);
        }
    }

    public static String getLogFileLocation(String baseLocation) {
        return LoggingUtils.getLogFileLocation(baseLocation, null);
    }

    public static String getLogFileLocation(String baseLocation, ServletContext context) {
        String location;
        String string = location = context != null ? GeoServerExtensions.getProperty((String)GEOSERVER_LOG_LOCATION, (ServletContext)context) : GeoServerExtensions.getProperty((String)GEOSERVER_LOG_LOCATION);
        if (location == null) {
            return baseLocation;
        }
        return location;
    }

    public static enum GeoToolsLoggingRedirection {
        Logback,
        JavaLogging,
        CommonsLogging,
        Log4J,
        Log4J2;


        public static GeoToolsLoggingRedirection findValue(String name) {
            for (GeoToolsLoggingRedirection value : GeoToolsLoggingRedirection.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return Log4J2;
        }
    }
}

