/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.util.List;
import javax.servlet.ServletContext;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class LoggingInitializer
implements GeoServerInitializer,
ApplicationContextAware,
GeoServerLifecycleHandler {
    ServletContext servletContext;
    GeoServerResourceLoader resourceLoader;
    LoggingListener listener;
    GeoServer geoServer;

    @Override
    public void onReset() {
    }

    @Override
    public void onDispose() {
    }

    @Override
    public void beforeReload() {
    }

    @Override
    public void onReload() {
        LoggingInfo previousLogging = this.listener.getCurrentLogging();
        LoggingInfo newLogging = this.geoServer.getLogging();
        if (previousLogging != null && !previousLogging.equals(newLogging)) {
            try {
                String logLocation = LoggingUtils.getLogFileLocation(newLogging.getLocation(), this.servletContext);
                LoggingUtils.initLogging(this.resourceLoader, newLogging.getLevel(), !newLogging.isStdOutLogging(), false, logLocation);
                newLogging.setLocation(logLocation);
                this.listener.setCurrentLogging(newLogging);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        if (!LoggingUtils.relinquishLog4jControl) {
            this.listener = new LoggingListener(this.resourceLoader, this.servletContext);
            geoServer.addListener(this.listener);
        }
    }

    public static class LoggingListener
    extends ConfigurationListenerAdapter {
        private final GeoServerResourceLoader resourceLoader;
        private LoggingInfo currentLogging = new LoggingInfoImpl();
        private ServletContext servletContext;

        public LoggingListener(GeoServerResourceLoader resourceLoader, ServletContext servletContext) {
            this.resourceLoader = resourceLoader;
            this.servletContext = servletContext;
        }

        public LoggingInfo getCurrentLogging() {
            return this.currentLogging;
        }

        public void setCurrentLogging(LoggingInfo currentLogging) {
            this.currentLogging = currentLogging;
        }

        @Override
        public void handleLoggingChange(LoggingInfo logging, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            this.currentLogging = logging;
            boolean reload = false;
            String loggingProfile = logging.getLevel();
            String loggingLocation = logging.getLocation();
            Boolean stdOutLogging = logging.isStdOutLogging();
            if (propertyNames.contains("level")) {
                loggingProfile = (String)newValues.get(propertyNames.indexOf("level"));
                reload = true;
            }
            if (propertyNames.contains("location")) {
                loggingLocation = (String)newValues.get(propertyNames.indexOf("location"));
                reload = true;
            }
            if (propertyNames.contains("stdOutLogging")) {
                stdOutLogging = (Boolean)newValues.get(propertyNames.indexOf("stdOutLogging"));
                reload = true;
            }
            loggingLocation = LoggingUtils.getLogFileLocation(loggingLocation, this.servletContext);
            if (reload) {
                try {
                    LoggingUtils.initLogging(this.resourceLoader, loggingProfile, stdOutLogging == false, false, loggingLocation);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

