/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.util.LegacyServicesReader;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class LegacyLoggingImporter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.confg");
    private String configFileName;
    private String logFile;
    private Boolean suppressStdOutLogging;

    private LegacyServicesReader reader(File dir) throws Exception {
        File servicesFile = new File(dir, "services.xml");
        if (!servicesFile.exists()) {
            throw new FileNotFoundException("Could not find services.xml under:" + dir.getAbsolutePath());
        }
        LegacyServicesReader reader = new LegacyServicesReader();
        reader.read(servicesFile);
        return reader;
    }

    public void imprt(File dir) throws Exception {
        LegacyServicesReader reader = this.reader(dir);
        Map<String, Object> global = reader.global();
        this.configFileName = (String)global.get("log4jConfigFile");
        this.logFile = (String)global.get("logLocation");
        this.suppressStdOutLogging = (Boolean)Converters.convert((Object)global.get("suppressStdOutLogging"), Boolean.class);
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public Boolean getSuppressStdOutLogging() {
        return this.suppressStdOutLogging;
    }
}

