/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import com.google.common.base.Stopwatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogValidator;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.HTTPStoreInfo;
import org.geoserver.catalog.RetypeFeatureTypeCallback;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.DefaultGeoServerLoader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.datadir.CatalogLoader;
import org.geoserver.config.datadir.ConfigLoader;
import org.geoserver.config.datadir.DataDirectoryWalker;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.password.ConfigurationPasswordEncryptionHelper;
import org.geotools.api.referencing.FactoryException;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataDirectoryGeoServerLoader
extends DefaultGeoServerLoader {
    private static final Logger LOGGER = Logging.getLogger((String)DataDirectoryGeoServerLoader.class.getPackage().getName());
    static final String GEOSERVER_DATA_DIR_LOADER_ENABLED = "GEOSERVER_DATA_DIR_LOADER_ENABLED";
    static final String GEOSERVER_DATA_DIR_LOADER_THREADS = "GEOSERVER_DATA_DIR_LOADER_THREADS";
    private final GeoServerDataDirectory dataDirectory;
    private final GeoServerSecurityManager securityManager;
    DataDirectoryWalker fileWalk;
    private GeoServerConfigurationLock configLock;

    public DataDirectoryGeoServerLoader(GeoServerDataDirectory dataDirectory, GeoServerSecurityManager securityManager, GeoServerConfigurationLock configLock) {
        super(dataDirectory.getResourceLoader());
        this.dataDirectory = dataDirectory;
        this.securityManager = securityManager;
        this.configLock = configLock;
    }

    public static boolean isEnabled(@Nullable ApplicationContext context) {
        String value = GeoServerExtensions.getProperty((String)GEOSERVER_DATA_DIR_LOADER_ENABLED, (ApplicationContext)context);
        return value == null || Boolean.parseBoolean(value);
    }

    @Override
    public void destroy() {
        this.fileWalk = null;
        super.destroy();
    }

    @Override
    protected void loadCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        this.initializeDependencies();
        super.loadCatalog(catalog, xp);
    }

    @Override
    protected Catalog readCatalog(XStreamPersister xp) throws Exception {
        CatalogImpl catalog = this.newTemporaryCatalog();
        xp.setCatalog(catalog);
        xp.setUnwrapNulls(false);
        boolean checkStores = this.checkStoresOnStartup(xp);
        catalog.setExtendedValidation(checkStores);
        catalog.setResourceLoader(this.resourceLoader);
        CatalogLoader catalogLoader = new CatalogLoader(catalog, this.fileWalker());
        catalogLoader.loadCatalog();
        this.decryptStorePasswords(catalog);
        return catalog;
    }

    @Override
    protected void readConfiguration(GeoServer geoServer, XStreamPersister xp) throws Exception {
        LOGGER.config("Loading GeoServer config...");
        if (this.isLegacyDatadir()) {
            super.readConfiguration(geoServer, xp);
        } else {
            Stopwatch stopWatch = Stopwatch.createStarted();
            ConfigLoader configLoader = new ConfigLoader(geoServer, this.fileWalker());
            configLoader.loadGeoServer();
            LOGGER.log(Level.CONFIG, "GeoServer config (settings and services) loaded in {0}", stopWatch.stop());
        }
    }

    private boolean isLegacyDatadir() {
        Resource legacyGlobalConfig = this.resourceLoader.get("services.xml");
        return Resources.exists((Resource)legacyGlobalConfig);
    }

    @Override
    protected void initializeDefaultStyles(Catalog catalog) {
    }

    protected CatalogImpl newTemporaryCatalog() {
        return new CatalogImpl();
    }

    private void decryptStorePasswords(CatalogImpl catalog) {
        catalog.getStores(HTTPStoreInfo.class).stream().filter(store -> store.getPassword() != null).map(ModificationProxy::unwrap).forEach(this::decodePasswords);
        catalog.getDataStores().stream().map(ModificationProxy::unwrap).forEach(this::decodePassword);
    }

    private void decodePasswords(HTTPStoreInfo store) {
        ConfigurationPasswordEncryptionHelper helper = this.passwordHelper();
        try {
            String decoded = helper.decode(store.getPassword());
            store.setPassword(decoded);
        }
        catch (RuntimeException e) {
            store.setEnabled(false);
            String msg = String.format("Error decrypting password for store %s:%s", store.getWorkspace().getName(), store.getName());
            LOGGER.log(Level.SEVERE, msg, e);
        }
    }

    private void decodePassword(DataStoreInfo store) {
        ConfigurationPasswordEncryptionHelper helper = this.passwordHelper();
        try {
            helper.decode(store);
        }
        catch (RuntimeException e) {
            store.setEnabled(false);
            String msg = String.format("Error decrypting password for store '%s:%s'. Store disabled.", store.getWorkspace().getName(), store.getName());
            LOGGER.log(Level.SEVERE, msg, e);
        }
    }

    private ConfigurationPasswordEncryptionHelper passwordHelper() {
        return this.securityManager.getConfigPasswordEncryptionHelper();
    }

    private DataDirectoryWalker fileWalker() {
        if (this.fileWalk == null) {
            this.fileWalk = new DataDirectoryWalker(this.dataDirectory, this.xpf, this.configLock);
        }
        return this.fileWalk;
    }

    private void initializeDependencies() {
        try {
            CRS.decode((String)"EPSG:4326");
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Error initializing CRS factories", e);
        }
        this.preLoadExtensions(CatalogValidator.class);
        this.preLoadExtensions(StyleHandler.class);
        this.preLoadExtensions(FeatureTypeCallback.class);
        this.preLoadExtensions(RetypeFeatureTypeCallback.class);
        this.preLoadExtensions(XStreamPersisterInitializer.class);
        this.preLoadExtensions(XStreamServiceLoader.class);
        DataStoreUtils.getAvailableDataStoreFactories().forEach(f -> {
            try {
                DataStoreUtils.aquireFactory(f.getDisplayName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void preLoadExtensions(Class<?> extensionType) {
        try {
            GeoServerExtensions.extensions(extensionType);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Error preloading " + extensionType.getCanonicalName(), e);
        }
    }
}

