/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.catalog.impl.ProxyList;
import org.geoserver.catalog.impl.WrappingProxy;
import org.springframework.util.ClassUtils;

public class ProxyUtils {
    static final Map<ProxyClassConstructorKey, Constructor> PROXY_CLASS_CACHE = new ConcurrentHashMap<ProxyClassConstructorKey, Constructor>();

    public static <T> T createProxy(T proxyObject, Class<? extends T> clazz, InvocationHandler h) {
        try {
            ArrayList<Class<T>> proxyInterfaces = new ArrayList<Class<T>>(ClassUtils.getAllInterfacesAsSet(proxyObject));
            boolean add = true;
            for (Class clazz2 : proxyInterfaces) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                add = false;
                break;
            }
            if (add) {
                proxyInterfaces = new ArrayList(proxyInterfaces);
                proxyInterfaces.add(clazz);
            }
            Object instance = Proxy.newProxyInstance(clazz.getClassLoader(), proxyInterfaces.toArray(new Class[proxyInterfaces.size()]), h);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unwrap(T object, Class<? extends InvocationHandler> handlerClass) {
        InvocationHandler h;
        if (object instanceof Proxy && (h = ProxyUtils.handler(object, handlerClass)) != null && h instanceof WrappingProxy) {
            return (T)((WrappingProxy)h).getProxyObject();
        }
        if (object instanceof ProxyList) {
            return (T)((ProxyList)object).proxyList;
        }
        return object;
    }

    public static <H extends InvocationHandler> H handler(Object object, Class<H> handlerClass) {
        InvocationHandler h;
        if (object instanceof Proxy && handlerClass.isInstance(h = Proxy.getInvocationHandler(object))) {
            return (H)((InvocationHandler)handlerClass.cast(h));
        }
        return null;
    }

    static final class ProxyClassConstructorKey {
        Class<?> c1;
        Class<?> c2;

        public ProxyClassConstructorKey(Class<?> c1, Class<?> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.c1 == null ? 0 : this.c1.hashCode());
            result = 31 * result + (this.c2 == null ? 0 : this.c2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyClassConstructorKey other = (ProxyClassConstructorKey)obj;
            if (this.c1 == null ? other.c1 != null : !this.c1.equals(other.c1)) {
                return false;
            }
            return !(this.c2 == null ? other.c2 != null : !this.c2.equals(other.c2));
        }
    }
}

