/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LockingCatalogFacade;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ProxyUtils;
import org.geoserver.catalog.impl.ResolvingProxyResolver;
import org.geoserver.ows.util.OwsUtils;

public abstract class AbstractCatalogFacade
implements CatalogFacade {
    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    protected void beforeSaved(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogInfo real = ModificationProxy.unwrap(object);
        this.getCatalog().fireModified(real, propertyNames, oldValues, newValues);
    }

    protected <T extends CatalogInfo> T commitProxy(T object) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(object);
        CatalogInfo real = (CatalogInfo)h.getProxyObject();
        h.commit();
        return (T)real;
    }

    protected void afterSaved(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogInfo real = ModificationProxy.unwrap(object);
        this.getCatalog().firePostModified(real, propertyNames, oldValues, newValues);
    }

    protected void resolve(LayerInfo layer) {
        this.setId(layer);
        ResolvingProxyResolver.resolve((CatalogInfo)layer, this.getCatalog());
    }

    protected void resolve(LayerGroupInfo layerGroup) {
        this.setId(layerGroup);
        ResolvingProxyResolver.resolve((CatalogInfo)layerGroup, this.getCatalog());
    }

    protected void resolve(StyleInfo style) {
        this.setId(style);
        ResolvingProxyResolver.resolve((CatalogInfo)style, this.getCatalog());
    }

    protected void resolve(MapInfo map) {
        this.setId(map);
        ResolvingProxyResolver.resolve((CatalogInfo)map, this.getCatalog());
    }

    protected void resolve(WorkspaceInfo workspace) {
        this.setId(workspace);
        ResolvingProxyResolver.resolve((CatalogInfo)workspace, this.getCatalog());
    }

    protected void resolve(NamespaceInfo namespace) {
        this.setId(namespace);
        ResolvingProxyResolver.resolve((CatalogInfo)namespace, this.getCatalog());
    }

    protected void resolve(StoreInfo store) {
        this.setId(store);
        ResolvingProxyResolver.resolve((CatalogInfo)store, this.getCatalog());
    }

    protected void resolve(ResourceInfo resource) {
        this.setId(resource);
        ResolvingProxyResolver.resolve((CatalogInfo)resource, this.getCatalog());
    }

    protected void setId(Object o) {
        if (OwsUtils.get((Object)o, (String)"id") == null) {
            String uid = new UID().toString();
            OwsUtils.set((Object)o, (String)"id", (Object)(o.getClass().getSimpleName() + "-" + uid));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static <T extends CatalogInfo> T copy(T obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
            CatalogInfo catalogInfo;
            oos.writeObject(obj);
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));){
                catalogInfo = (CatalogInfo)ois.readObject();
            }
            return (T)catalogInfo;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends CatalogInfo> T syncInfo(T obj, boolean deep, Catalog catalog) {
        obj = AbstractCatalogFacade.unwrap(obj);
        if (deep) {
            obj = AbstractCatalogFacade.copy(obj);
        }
        if (catalog != null) {
            OwsUtils.set(obj, (String)"catalog", (Object)catalog);
        }
        return obj;
    }

    public static void syncFromTo(CatalogFacade source, CatalogFacade target, boolean deep) {
        target = ProxyUtils.unwrap(target, LockingCatalogFacade.class);
        for (WorkspaceInfo workspaceInfo : source.getWorkspaces()) {
            target.add(AbstractCatalogFacade.syncInfo(workspaceInfo, deep, null));
        }
        for (NamespaceInfo namespaceInfo : source.getNamespaces()) {
            target.add(AbstractCatalogFacade.syncInfo(namespaceInfo, deep, null));
        }
        for (StoreInfo storeInfo : source.getStores(StoreInfo.class)) {
            target.add(AbstractCatalogFacade.syncInfo(storeInfo, deep, target.getCatalog()));
        }
        for (ResourceInfo resourceInfo : source.getResources(ResourceInfo.class)) {
            target.add(AbstractCatalogFacade.syncInfo(resourceInfo, deep, target.getCatalog()));
        }
        for (StyleInfo styleInfo : source.getStyles()) {
            target.add(AbstractCatalogFacade.syncInfo(styleInfo, deep, target.getCatalog()));
        }
        for (LayerInfo layerInfo : source.getLayers()) {
            target.add(AbstractCatalogFacade.syncInfo(layerInfo, deep, null));
        }
        for (LayerGroupInfo layerGroupInfo : source.getLayerGroups()) {
            target.add(AbstractCatalogFacade.syncInfo(layerGroupInfo, deep, null));
        }
        for (MapInfo mapInfo : source.getMaps()) {
            target.add(AbstractCatalogFacade.syncInfo(mapInfo, deep, null));
        }
        WorkspaceInfo defaultWorkspace = source.getDefaultWorkspace();
        NamespaceInfo namespaceInfo = source.getDefaultNamespace();
        if (defaultWorkspace != null) {
            target.setDefaultWorkspace(target.getWorkspace(defaultWorkspace.getId()));
        }
        if (namespaceInfo != null) {
            target.setDefaultNamespace(target.getNamespace(namespaceInfo.getId()));
        }
        for (WorkspaceInfo ws : source.getWorkspaces()) {
            DataStoreInfo defaultDataStore = source.getDefaultDataStore(ws);
            if (defaultDataStore == null) continue;
            target.setDefaultDataStore(target.getWorkspace(ws.getId()), target.getStore(defaultDataStore.getId(), DataStoreInfo.class));
        }
    }
}

