/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.Serializable;
import java.math.BigDecimal;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;

public interface DimensionInfo
extends Serializable {
    public static final String CUSTOM_DIM_PREFIX = "DIM_";
    public static final String ELEVATION_UNITS = "EPSG:5030";
    public static final String ELEVATION_UNIT_SYMBOL = "m";
    public static final String TIME_UNITS = "ISO8601";
    public static final int DEFAULT_MAX_REQUESTED_DIMENSION_VALUES = 100;
    public static final String NEAREST_FAIL_BEHAVIOR_KEY = "org.geoserver.wms.nearestFail";
    public static final NearestFailBehavior DEFAULT_NEAREST_FAIL = NearestFailBehavior.valueOf(System.getProperty("org.geoserver.wms.nearestFail", NearestFailBehavior.IGNORE.name()));

    public static String getDimensionKey(String name) {
        if ("time".equalsIgnoreCase(name) || "elevation".equalsIgnoreCase(name)) {
            return name;
        }
        return CUSTOM_DIM_PREFIX + name.toUpperCase();
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public String getAttribute();

    public void setAttribute(String var1);

    public String getEndAttribute();

    public void setEndAttribute(String var1);

    public DimensionPresentation getPresentation();

    public void setPresentation(DimensionPresentation var1);

    public BigDecimal getResolution();

    public void setResolution(BigDecimal var1);

    public String getUnits();

    public void setUnits(String var1);

    public String getUnitSymbol();

    public void setUnitSymbol(String var1);

    public DimensionDefaultValueSetting getDefaultValue();

    public void setDefaultValue(DimensionDefaultValueSetting var1);

    public boolean isNearestMatchEnabled();

    public void setNearestMatchEnabled(boolean var1);

    public boolean isRawNearestMatchEnabled();

    public void setRawNearestMatchEnabled(boolean var1);

    public String getAcceptableInterval();

    public void setAcceptableInterval(String var1);

    public String getStartValue();

    public void setStartValue(String var1);

    public String getEndValue();

    public void setEndValue(String var1);

    public NearestFailBehavior getNearestFailBehavior();

    public void setNearestFailBehavior(NearestFailBehavior var1);

    public static enum NearestFailBehavior {
        IGNORE,
        EXCEPTION;

    }
}

