/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class ManifestLoader {
    private static final Logger LOGGER = Logging.getLogger((String)ManifestLoader.class.toString());
    public static final String RESOURCE_NAME_REGEX = "resourceNameRegex";
    public static final String RESOURCE_ATTRIBUTE_EXCLUSIONS = "resourceAttributeExclusions";
    public static final String VERSION_ATTRIBUTE_INCLUSIONS = "versionAttributeInclusions";
    public static final String PROPERTIES_FILE = "manifest.properties";
    private static Properties props;
    private static Pattern resourceNameRegex;
    private static String[] resourceAttributeExclusions;
    private static String[] versionAttributeInclusions;
    private static ClassLoader classLoader;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public ManifestLoader(GeoServerResourceLoader loader) throws Exception {
        classLoader = loader.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Could not get the class loader from GeoServerResourceLoader");
        }
        props = new Properties();
        try (InputStream is = classLoader.getResourceAsStream("org/geoserver/manifest.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        Resource resource = loader.get(PROPERTIES_FILE);
        if (resource.getType() == Resource.Type.RESOURCE) {
            try (InputStream is = resource.in();){
                props.load(is);
            }
            catch (IOException e2) {
                LOGGER.log(Level.FINER, e2.getMessage(), e2);
            }
        }
        try {
            resourceNameRegex = Pattern.compile(props.getProperty(RESOURCE_NAME_REGEX) + "!/META-INF/MANIFEST.MF");
        }
        catch (PatternSyntaxException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw e;
        }
        String ae = props.getProperty(RESOURCE_ATTRIBUTE_EXCLUSIONS);
        resourceAttributeExclusions = ae != null ? ae.split(",") : new String[0];
        String ai = props.getProperty(VERSION_ATTRIBUTE_INCLUSIONS);
        if (ai == null) {
            throw new Exception("Include attribute array cannot be null");
        }
        versionAttributeInclusions = ai.split(",");
    }

    private static AboutModel getAboutModel(ClassLoader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("Unable to run with null arguments");
        }
        AboutModel model = new AboutModel();
        Map<String, Manifest> manifests = ManifestLoader.loadManifest(loader);
        for (Map.Entry<String, Manifest> entry : manifests.entrySet()) {
            model.add(AboutModel.ManifestModel.parseManifest(ManifestLoader.trimName(entry.getKey()), entry.getValue(), new AboutModel.ManifestModel.ExcludeAttributeFilter(resourceAttributeExclusions)));
        }
        return model;
    }

    private static Map<String, Manifest> loadManifest(ClassLoader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("Unable to run with null arguments");
        }
        HashMap<String, Manifest> manifests = new HashMap<String, Manifest>();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loading resources: " + resource.getFile());
                }
                try {
                    InputStream is = resource.openStream();
                    try {
                        manifests.put(resource.getPath(), new Manifest(is));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error loading resources file: " + e.getLocalizedMessage(), e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error loading resources file: " + e.getLocalizedMessage(), e);
        }
        return manifests;
    }

    private static String trimName(String path) {
        Matcher m = resourceNameRegex.matcher(path);
        if (m.matches()) {
            return m.group(1);
        }
        String name = path.substring(0, path.length() - 22);
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public static AboutModel getResources() {
        return ManifestLoader.getAboutModel(classLoader);
    }

    public static Manifest getManifest(Class<?> clz) {
        Manifest manifest;
        block9: {
            String resource = "/" + clz.getName().replace(".", "/") + ".class";
            String fullPath = clz.getResource(resource).toString();
            String archivePath = fullPath.substring(0, fullPath.length() - resource.length());
            if (archivePath.endsWith("\\WEB-INF\\classes") || archivePath.endsWith("/WEB-INF/classes")) {
                archivePath = archivePath.substring(0, archivePath.length() - "/WEB-INF/classes".length());
            }
            InputStream input = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
            try {
                manifest = new Manifest(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Loading MANIFEST for class " + clz + " failed!", e);
                }
            }
            input.close();
        }
        return manifest;
    }

    public static AboutModel getVersions() {
        Object path;
        Manifest manifest;
        Class geoserver_class;
        if (classLoader == null) {
            throw new IllegalArgumentException("Unable to run with null classLoader");
        }
        AboutModel model = new AboutModel();
        try {
            Object geoserverPath = GeoServer.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            geoserverPath = (String)geoserverPath + "!/META-INF/MANIFEST.MF";
            geoserver_class = GeoServer.class;
            manifest = ManifestLoader.getManifest(geoserver_class);
            if (manifest != null) {
                model.add(AboutModel.ManifestModel.parseManifest("GeoServer", manifest, new AboutModel.ManifestModel.IncludeAttributeFilter(versionAttributeInclusions)));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error looking up geoserver package", e);
        }
        try {
            path = GeoTools.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            path = (String)path + "!/META-INF/MANIFEST.MF";
            geoserver_class = GeoTools.class;
            manifest = ManifestLoader.getManifest(geoserver_class);
            if (manifest != null) {
                model.add(AboutModel.ManifestModel.parseManifest("GeoTools", manifest, new AboutModel.ManifestModel.IncludeAttributeFilter(versionAttributeInclusions)));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error looking up geoserver package", e);
        }
        try {
            path = Class.forName("org.geowebcache.GeoWebCache").getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            path = (String)path + "!/META-INF/MANIFEST.MF";
            geoserver_class = Class.forName("org.geowebcache.GeoWebCache");
            manifest = ManifestLoader.getManifest(geoserver_class);
            if (manifest != null) {
                model.add(AboutModel.ManifestModel.parseManifest("GeoWebCache", manifest, new AboutModel.ManifestModel.IncludeAttributeFilter(versionAttributeInclusions)));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error looking up org.geowebcache package", e);
        }
        return model;
    }

    public static class AboutModel {
        private TreeSet<ManifestModel> manifests;

        public AboutModel() {
            this.manifests = new TreeSet<ManifestModel>(new ManifestModel.ManifestComparator());
        }

        public AboutModel(AboutModel am) throws IllegalArgumentException {
            if (am == null) {
                throw new IllegalArgumentException("Unable to initialize model with a null model");
            }
            this.manifests = new TreeSet<ManifestModel>((SortedSet<ManifestModel>)am.getManifests());
        }

        private AboutModel(NavigableSet<ManifestModel> manifests) throws IllegalArgumentException {
            if (manifests == null) {
                throw new IllegalArgumentException("Unable to initialize model with a null manifests tree");
            }
            this.manifests = new TreeSet<ManifestModel>((SortedSet<ManifestModel>)manifests);
        }

        public AboutModel filterNameByRange(String from, String to) throws IllegalArgumentException {
            if (from == null || to == null) {
                throw new IllegalArgumentException("Unable to parse from or to are null");
            }
            return new AboutModel(this.getManifests().subSet(new ManifestModel(from), true, new ManifestModel(to), true));
        }

        public AboutModel filterNameByRegex(String regex) throws IllegalArgumentException {
            if (regex == null) {
                throw new IllegalArgumentException("Unable to parse regex is null");
            }
            AboutModel am = new AboutModel(new TreeSet<ManifestModel>(new ManifestModel.ManifestComparator()));
            for (ManifestModel tModel : this.manifests) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(tModel.getName());
                }
                if (!tModel.getName().matches(regex)) continue;
                am.getManifests().add(tModel);
            }
            return am;
        }

        public AboutModel filterPropertyByKey(String key) throws IllegalArgumentException {
            if (key == null) {
                throw new IllegalArgumentException("Unable to parse key is null");
            }
            AboutModel am = new AboutModel();
            for (ManifestModel tModel : this.manifests) {
                if (!this.filterPropertyByKey(tModel, key)) continue;
                am.getManifests().add(tModel);
            }
            return am;
        }

        public AboutModel filterPropertyByValue(String value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException("Unable to parse: value is null");
            }
            AboutModel am = new AboutModel();
            for (ManifestModel tModel : this.manifests) {
                if (!this.filterByPropertyValue(tModel, value)) continue;
                am.getManifests().add(tModel);
            }
            return am;
        }

        public AboutModel filterPropertyByKeyValue(String value, String key) throws IllegalArgumentException {
            if (value == null && key == null) {
                throw new IllegalArgumentException("Unable to parse: property or key are null");
            }
            AboutModel am = new AboutModel();
            for (ManifestModel tModel : this.manifests) {
                if (!this.filterPropertyByKeyValue(tModel, key, value)) continue;
                am.getManifests().add(tModel);
            }
            return am;
        }

        private boolean filterPropertyByKeyValue(ManifestModel tModel, String key, String value) {
            for (Map.Entry<String, String> e : tModel.getEntries().entrySet()) {
                if (!e.getKey().matches(key) || !e.getValue().matches(value)) continue;
                return true;
            }
            return false;
        }

        private boolean filterPropertyByKey(ManifestModel tModel, String key) {
            for (Map.Entry<String, String> e : tModel.getEntries().entrySet()) {
                if (!e.getKey().matches(key)) continue;
                return true;
            }
            return false;
        }

        private boolean filterByPropertyValue(ManifestModel tModel, String value) {
            for (Map.Entry<String, String> e : tModel.getEntries().entrySet()) {
                if (!e.getValue().matches(value)) continue;
                return true;
            }
            return false;
        }

        public boolean add(String name, Manifest manifest) {
            return this.manifests.add(ManifestModel.parseManifest(name, manifest, new ManifestModel.ExcludeAttributeFilter(resourceAttributeExclusions)));
        }

        public boolean add(ManifestModel manifest) {
            return this.manifests.add(manifest);
        }

        public boolean remove(String name) {
            if (name != null) {
                return this.manifests.remove(new ManifestModel(name));
            }
            return false;
        }

        public TreeSet<ManifestModel> getManifests() {
            return this.manifests;
        }

        public static class ManifestModel {
            private final String name;
            private final Map<String, String> entries;

            public String getName() {
                return this.name;
            }

            public Map<String, String> getEntries() {
                return this.entries;
            }

            public ManifestModel(String name) {
                this.name = name;
                this.entries = new HashMap<String, String>();
            }

            public void putAllEntries(Map<String, String> entries) {
                this.entries.putAll(entries);
            }

            public void putEntry(String name, String value) {
                this.entries.put(name, value);
            }

            private static ManifestModel parseManifest(String name, Manifest manifest, AttributesFilter<Map<String, String>> filter) {
                ManifestModel m = new ManifestModel(name);
                try {
                    m.putAllEntries(filter.filter(manifest.getMainAttributes()));
                }
                catch (Exception e1) {
                    LOGGER.log(Level.FINER, e1.getMessage(), e1);
                }
                Map<String, Attributes> attrs = manifest.getEntries();
                for (Map.Entry<String, Attributes> entry : attrs.entrySet()) {
                    try {
                        m.putAllEntries(filter.filter(entry.getValue()));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINER, e.getMessage(), e);
                    }
                }
                return m;
            }

            public static class ExcludeAttributeFilter
            implements AttributesFilter<Map<String, String>> {
                private final String[] exclude;

                public ExcludeAttributeFilter(String[] exclude) {
                    this.exclude = exclude;
                }

                @Override
                public Map<String, String> filter(Attributes at) throws Exception {
                    return ExcludeAttributeFilter.filterExcludingAttributes(at, this.exclude);
                }

                private static Map<String, String> filterExcludingAttributes(Attributes at, String[] exclude) {
                    if (at == null) {
                        throw new IllegalArgumentException("Null arguments");
                    }
                    if (exclude == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "No exceptions");
                        }
                        exclude = new String[]{};
                    }
                    HashMap<String, String> ret = new HashMap<String, String>();
                    Iterator<Object> it = at.keySet().iterator();
                    while (it.hasNext()) {
                        String attrName = it.next().toString();
                        boolean skip = false;
                        int i = 0;
                        while (i < exclude.length) {
                            if (!attrName.matches(exclude[i++])) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                        ret.put(attrName, at.getValue(attrName));
                    }
                    return ret;
                }
            }

            public static class IncludeAttributeFilter
            implements AttributesFilter<Map<String, String>> {
                private final String[] include;

                public IncludeAttributeFilter(String[] include) {
                    this.include = include;
                }

                @Override
                public Map<String, String> filter(Attributes at) throws Exception {
                    return IncludeAttributeFilter.filterIncludingAttributes(at, this.include);
                }

                private static Map<String, String> filterIncludingAttributes(Attributes at, String[] include) {
                    if (at == null) {
                        throw new IllegalArgumentException("Null argument");
                    }
                    HashMap<String, String> ret = new HashMap<String, String>();
                    if (include == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "No includes: including all");
                        }
                        for (Map.Entry<Object, Object> entry : at.entrySet()) {
                            String attrName = entry.getKey().toString();
                            ret.put(attrName, entry.getValue().toString());
                        }
                    } else {
                        block1: for (Map.Entry<Object, Object> entry : at.entrySet()) {
                            String attrName = entry.getKey().toString();
                            int i = 0;
                            while (i < include.length) {
                                String[] key;
                                if (!attrName.matches((key = include[i++].split(":"))[0])) continue;
                                ret.put(key.length > 1 ? key[1] : key[0], entry.getValue().toString());
                                continue block1;
                            }
                        }
                    }
                    return ret;
                }
            }

            public static interface AttributesFilter<T> {
                public T filter(Attributes var1) throws Exception;
            }

            public static class ManifestComparator
            implements Comparator<ManifestModel> {
                @Override
                public int compare(ManifestModel o1, ManifestModel o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            }
        }

        public static enum AboutModelType {
            VERSIONS,
            RESOURCES;

        }
    }
}

