/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.Classification;
import it.geosolutions.jaiext.classbreaks.ClassificationMethod;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class QuantileClassification
extends Classification {
    static final Logger LOGGER = Logger.getLogger(Classification.class.getName());
    int[] counts;
    SortedMap<Double, Integer>[] tables;

    public QuantileClassification(int numBands) {
        super(ClassificationMethod.QUANTILE, numBands);
        this.counts = new int[numBands];
        this.tables = new SortedMap[numBands];
    }

    public void count(double value, int band) {
        int n = band;
        this.counts[n] = this.counts[n] + 1;
        SortedMap<Double, Integer> table = this.getTable(band);
        Integer count = (Integer)table.get(value);
        table.put(value, count != null ? new Integer(count + 1) : new Integer(1));
    }

    public SortedMap<Double, Integer> getTable(int band) {
        SortedMap<Double, Integer> table = this.tables[band];
        if (table == null) {
            this.tables[band] = table = new TreeMap<Double, Integer>();
        }
        return table;
    }

    public int getCount(int band) {
        return this.counts[band];
    }

    void printTable() {
        for (int i = 0; i < this.tables.length; ++i) {
            SortedMap<Double, Integer> table = this.getTable(i);
            for (Map.Entry<Double, Integer> e : table.entrySet()) {
                LOGGER.info(String.format("%f: %d", e.getKey(), e.getValue()));
            }
        }
    }
}

