/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleHierarchyHelper;
import org.geoserver.security.jdbc.JDBCRoleService;

public class JDBCRoleStore
extends JDBCRoleService
implements GeoServerRoleStore {
    protected boolean modified;
    protected Connection connection;

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = super.getConnection();
        }
        return this.connection;
    }

    @Override
    protected void closeConnection(Connection con) throws SQLException {
    }

    protected void releaseConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void load() throws IOException {
        try {
            this.getConnection().rollback();
            this.releaseConnection();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRoleProperties(GeoServerRole role, Connection con) throws SQLException, IOException {
        if (role.getProperties().isEmpty()) {
            return;
        }
        PreparedStatement ps = this.getDMLStatement("roleprops.insert", con);
        try {
            for (Object key : role.getProperties().keySet()) {
                Object propertyVal = role.getProperties().get(key);
                ps.setString(1, role.getAuthority());
                ps.setString(2, key.toString());
                ps.setObject(3, propertyVal);
                ps.execute();
            }
        }
        finally {
            this.closeFinally(null, ps, null);
        }
    }

    public void addRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.insert", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            this.addRoleProperties(role, con);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void updateRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.update", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("roleprops.deleteForRole", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            this.addRoleProperties(role, con);
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public boolean removeRole(GeoServerRole role) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        boolean retval = false;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.delete", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            retval = ps.getUpdateCount() > 0;
            ps.close();
            ps = this.getDMLStatement("userroles.deleteRole", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("grouproles.deleteRole", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("roleprops.deleteForRole", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("roles.deleteParent", con);
            ps.setString(1, role.getAuthority());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
        return retval;
    }

    public void store() throws IOException {
        try {
            this.getConnection().commit();
            this.releaseConnection();
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        this.setModified(false);
    }

    public void associateRoleToUser(GeoServerRole role, String username) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userroles.insert", con);
            ps.setString(1, role.getAuthority());
            ps.setString(2, username);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void disAssociateRoleFromUser(GeoServerRole role, String username) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("userroles.delete", con);
            ps.setString(1, role.getAuthority());
            ps.setString(2, username);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void associateRoleToGroup(GeoServerRole role, String groupname) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("grouproles.insert", con);
            ps.setString(1, role.getAuthority());
            ps.setString(2, groupname);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void disAssociateRoleFromGroup(GeoServerRole role, String groupname) throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("grouproles.delete", con);
            ps.setString(1, role.getAuthority());
            ps.setString(2, groupname);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setParentRole(GeoServerRole role, GeoServerRole parentRole) throws IOException {
        RoleHierarchyHelper helper = new RoleHierarchyHelper(this.getParentMappings());
        if (!helper.isValidParent(role.getAuthority(), parentRole == null ? null : parentRole.getAuthority())) {
            throw new IOException(parentRole.getAuthority() + " is not a valid parent for " + role.getAuthority());
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("roles.parentUpdate", con);
            if (parentRole == null) {
                ps.setNull(1, 12);
            } else {
                ps.setString(1, parentRole.getAuthority());
            }
            ps.setString(2, role.getAuthority());
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void clear() throws IOException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this.getDMLStatement("grouproles.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("userroles.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("roleprops.deleteAll", con);
            ps.execute();
            ps.close();
            ps = this.getDMLStatement("roles.deleteAll", con);
            ps.execute();
        }
        catch (SQLException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                this.closeFinally(con, ps, null);
                throw throwable;
            }
        }
        this.closeFinally(con, ps, null);
        this.setModified(true);
    }

    public void initializeFromService(GeoServerRoleService service) throws IOException {
        JDBCRoleService jdbcService = (JDBCRoleService)service;
        this.name = service.getName();
        this.adminRoleName = jdbcService.adminRoleName;
        this.groupAdminRoleName = jdbcService.groupAdminRoleName;
        this.datasource = jdbcService.datasource;
        this.ddlProps = jdbcService.ddlProps;
        this.dmlProps = jdbcService.dmlProps;
        this.securityManager = service.getSecurityManager();
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

