/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Date;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultPeriodTest {
    private Period period1;
    private Period period2;

    @Before
    public void setUp() {
        Calendar cal = Calendar.getInstance();
        cal.set(1995, 1, 1);
        DefaultInstant begining1 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2000, 1, 1);
        DefaultInstant ending1 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2000, 1, 1);
        DefaultInstant begining2 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2012, 1, 1);
        DefaultInstant ending2 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        this.period1 = new DefaultPeriod((Instant)begining1, (Instant)ending1);
        this.period2 = new DefaultPeriod((Instant)begining2, (Instant)ending2);
    }

    @After
    public void tearDown() {
        this.period1 = null;
        this.period2 = null;
    }

    @Test
    public void testGetBeginning() {
        Instant result = this.period1.getBeginning();
        Assert.assertNotEquals((Object)this.period2.getBeginning(), (Object)result);
    }

    @Test
    public void testSetBegining_Instant() {
        Instant result = this.period1.getBeginning();
        DefaultInstant newInstant = new DefaultInstant((Position)new DefaultPosition(new Date()));
        ((DefaultPeriod)this.period1).setBegining((Instant)newInstant);
        Assert.assertNotEquals((Object)this.period1.getBeginning(), (Object)result);
    }

    @Test
    public void testSetBegining_Date() {
        Date result = this.period1.getBeginning().getPosition().getDate();
        ((DefaultPeriod)this.period1).setBegining(new Date());
        Assert.assertNotEquals((Object)this.period1.getBeginning().getPosition().getDate(), (Object)result);
    }

    @Test
    public void testGetEnding() {
        Instant result = this.period1.getEnding();
        Assert.assertNotEquals((Object)this.period2.getEnding(), (Object)result);
    }

    @Test
    public void testSetEnding_Instant() {
        Instant result = this.period1.getEnding();
        DefaultInstant newInstant = new DefaultInstant((Position)new DefaultPosition(new Date()));
        ((DefaultPeriod)this.period1).setEnding((Instant)newInstant);
        Assert.assertNotEquals((Object)this.period1.getEnding(), (Object)result);
    }

    @Test
    public void testSetEnding_Date() {
        Date result = this.period1.getEnding().getPosition().getDate();
        ((DefaultPeriod)this.period1).setEnding(new Date());
        Assert.assertNotEquals((Object)this.period1.getEnding().getPosition().getDate(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.period1);
        Assert.assertEquals((Object)this.period1, (Object)this.period1);
        Assert.assertNotEquals((Object)this.period1, (Object)this.period2);
    }

    @Test
    public void testHashCode() {
        int result = this.period1.hashCode();
        Assert.assertNotEquals((long)this.period2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.period1.toString();
        Assert.assertNotEquals((Object)this.period2.toString(), (Object)result);
    }
}

