/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import javax.measure.Unit;
import org.geotools.api.temporal.IntervalLength;
import org.geotools.temporal.object.DefaultIntervalLength;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import si.uom.SI;

public class DefaultIntervalLengthTest {
    private IntervalLength intervalLength1;
    private IntervalLength intervalLength2;

    @Before
    public void setUp() {
        Unit unit1 = SI.SECOND;
        Unit unit2 = SI.SECOND.multiply(3600.0);
        int radix1 = 10;
        int radix2 = 10;
        int factor1 = 3;
        int factor2 = 6;
        int value1 = 7;
        int value2 = 12;
        this.intervalLength1 = new DefaultIntervalLength(unit1, radix1, factor1, value1);
        this.intervalLength2 = new DefaultIntervalLength(unit2, radix2, factor2, value2);
    }

    @After
    public void tearDown() {
        this.intervalLength1 = null;
        this.intervalLength2 = null;
    }

    @Test
    public void testGetUnit() {
        Unit result = this.intervalLength1.getUnit();
        Assert.assertNotEquals((Object)this.intervalLength2.getUnit(), (Object)result);
    }

    @Test
    public void testGetRadix() {
        int result = this.intervalLength1.getRadix();
        Assert.assertEquals((long)this.intervalLength2.getRadix(), (long)result);
    }

    @Test
    public void testGetFactor() {
        int result = this.intervalLength1.getFactor();
        Assert.assertNotEquals((long)this.intervalLength2.getFactor(), (long)result);
    }

    @Test
    public void testGetValue() {
        int result = this.intervalLength1.getValue();
        Assert.assertNotEquals((long)this.intervalLength2.getValue(), (long)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.intervalLength1);
        Assert.assertEquals((Object)this.intervalLength1, (Object)this.intervalLength1);
        Assert.assertNotEquals((Object)this.intervalLength1, (Object)this.intervalLength2);
    }

    @Test
    public void testHashCode() {
        int result = this.intervalLength1.hashCode();
        Assert.assertNotEquals((long)this.intervalLength2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.intervalLength1.toString();
        Assert.assertNotEquals((Object)this.intervalLength2.toString(), (Object)result);
    }
}

