/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import java.util.List;
import org.geotools.geometry.jts.JTSTest;
import org.locationtech.jts.geom.Coordinate;

public class JTSTestBase {
    protected static final double TOL = 1.0E-6;
    protected static final int[] XPOINTS = new int[]{0, 15, 30, 45, 60, 75, 90, 75, 60, 45, 30, 15};
    protected static final int[] YPOINTS = new int[]{0, 20, 10, 20, 10, 20, 0, -20, -10, -20, -10, -20};
    protected static final int NPOINTS = XPOINTS.length;

    protected Coordinate[] getLineCoords() {
        return this.getCoords(0);
    }

    protected Coordinate[] getLineCoords(int offset) {
        return this.getCoords(offset);
    }

    protected Coordinate[] getPolyCoords() {
        return this.getPolyCoords(0);
    }

    protected Coordinate[] getPolyCoords(int offset) {
        Coordinate[] coords = new Coordinate[JTSTest.NPOINTS + 1];
        System.arraycopy(this.getCoords(offset), 0, coords, 0, NPOINTS);
        coords[JTSTest.NPOINTS] = new Coordinate(coords[0]);
        return coords;
    }

    private Coordinate[] getCoords(int offset) {
        Coordinate[] coords = new Coordinate[JTSTest.NPOINTS];
        for (int i = 0; i < JTSTest.NPOINTS; ++i) {
            coords[i] = new Coordinate((double)(JTSTest.XPOINTS[i] + offset), (double)(JTSTest.YPOINTS[i] + offset));
        }
        return coords;
    }

    protected static class CoordList {
        private static final double TOL = 1.0E-4;
        private List<Coordinate> coords;

        CoordList(Coordinate ... coordArray) {
            this.coords = Arrays.asList(coordArray);
        }

        public boolean contains(Coordinate coord) {
            for (Coordinate c : this.coords) {
                if (!this.equal2D(c, coord)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAll(Coordinate ... coordArray) {
            for (Coordinate c : coordArray) {
                if (this.contains(c)) continue;
                return false;
            }
            return true;
        }

        private boolean equal2D(Coordinate c0, Coordinate c1) {
            if (c0 == null || c1 == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            return Math.abs(c0.x - c1.x) < 1.0E-4 && Math.abs(c0.y - c1.y) < 1.0E-4;
        }
    }
}

