/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class JTSSmoothTest
extends JTSTestBase {
    private GeometryFactory factory;

    @Before
    public void setup() {
        this.factory = new GeometryFactory();
    }

    @Test(expected=IllegalArgumentException.class)
    public void smoothWithNullGeometry() {
        JTS.smooth(null, (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void smoothWithNullFactory() {
        LineString line = this.factory.createLineString(this.getLineCoords());
        JTS.smooth((Geometry)line, (double)0.0, null);
    }

    @Test
    public void smoothPointReturnsSameObject() {
        Point point = this.factory.createPoint(new Coordinate());
        Geometry smoothed = JTS.smooth((Geometry)point, (double)0.0);
        Assert.assertSame((Object)smoothed, (Object)point);
    }

    @Test
    public void smoothMultiPointReturnsSameObject() {
        Coordinate[] coords = this.getLineCoords();
        MultiPoint mpoint = this.factory.createMultiPoint((CoordinateSequence)new CoordinateArraySequence(coords));
        Geometry smoothed = JTS.smooth((Geometry)mpoint, (double)0.0);
        Assert.assertSame((Object)smoothed, (Object)mpoint);
    }

    @Test
    public void smoothLineString() {
        Coordinate[] coords = this.getLineCoords();
        LineString line = this.factory.createLineString(coords);
        Geometry smoothed = JTS.smooth((Geometry)line, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof LineString));
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(smoothed.getCoordinates());
        Assert.assertTrue((boolean)list.containsAll(coords));
        Envelope lineEnv = line.getEnvelopeInternal();
        Envelope smoothEnv = smoothed.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(lineEnv));
    }

    @Test
    public void smoothLinearRing() {
        Coordinate[] coords = this.getPolyCoords();
        LinearRing line = this.factory.createLinearRing(coords);
        Geometry smoothed = JTS.smooth((Geometry)line, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof LinearRing));
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(smoothed.getCoordinates());
        Assert.assertTrue((boolean)list.containsAll(coords));
        Envelope lineEnv = line.getEnvelopeInternal();
        Envelope smoothEnv = smoothed.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(lineEnv));
    }

    @Test
    public void smoothMultiLineString() {
        LineString[] lines = new LineString[]{this.factory.createLineString(this.getLineCoords(0)), this.factory.createLineString(this.getLineCoords(10)), this.factory.createLineString(this.getLineCoords(20))};
        MultiLineString mls = this.factory.createMultiLineString(lines);
        Geometry smoothed = JTS.smooth((Geometry)mls, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof MultiLineString));
        Assert.assertEquals((long)3L, (long)smoothed.getNumGeometries());
        Envelope mlsEnv = mls.getEnvelopeInternal();
        Envelope smoothEnv = smoothed.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(mlsEnv));
    }

    @Test
    public void smoothPolygon() {
        Coordinate[] coords = this.getPolyCoords();
        Polygon poly = this.factory.createPolygon(this.factory.createLinearRing(coords), null);
        Geometry smoothed = JTS.smooth((Geometry)poly, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof Polygon));
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(smoothed.getCoordinates());
        Assert.assertTrue((boolean)list.containsAll(coords));
        Envelope polyEnv = poly.getEnvelopeInternal();
        Envelope smoothEnv = smoothed.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(polyEnv));
    }

    @Test
    public void smoothMultiPolygon() {
        Polygon[] polys = new Polygon[]{this.factory.createPolygon(this.factory.createLinearRing(this.getPolyCoords(0)), null), this.factory.createPolygon(this.factory.createLinearRing(this.getPolyCoords(10)), null), this.factory.createPolygon(this.factory.createLinearRing(this.getPolyCoords(20)), null)};
        MultiPolygon mp = this.factory.createMultiPolygon(polys);
        Geometry smoothed = JTS.smooth((Geometry)mp, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof MultiPolygon));
        Assert.assertEquals((long)3L, (long)smoothed.getNumGeometries());
        Envelope mpEnv = mp.getEnvelopeInternal();
        Envelope smoothEnv = smoothed.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(mpEnv));
    }

    @Test
    public void smoothGeometryCollection() {
        Geometry[] geoms = new Geometry[]{this.factory.createPoint(new Coordinate()), this.factory.createLineString(this.getLineCoords()), this.factory.createPolygon(this.factory.createLinearRing(this.getPolyCoords()), null)};
        GeometryCollection gc = this.factory.createGeometryCollection(geoms);
        Geometry smoothed = JTS.smooth((Geometry)gc, (double)0.0);
        Assert.assertTrue((boolean)(smoothed instanceof GeometryCollection));
        Assert.assertEquals((long)3L, (long)smoothed.getNumGeometries());
        Assert.assertSame((Object)geoms[0], (Object)smoothed.getGeometryN(0));
        Geometry g = smoothed.getGeometryN(1);
        Assert.assertTrue((boolean)(g instanceof LineString));
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(g.getCoordinates());
        Assert.assertTrue((boolean)list.containsAll(geoms[1].getCoordinates()));
        Envelope inEnv = geoms[1].getEnvelopeInternal();
        Envelope smoothEnv = g.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(inEnv));
        g = smoothed.getGeometryN(2);
        Assert.assertTrue((boolean)(g instanceof Polygon));
        list = new JTSTestBase.CoordList(g.getCoordinates());
        Assert.assertTrue((boolean)list.containsAll(geoms[2].getCoordinates()));
        inEnv = geoms[2].getEnvelopeInternal();
        smoothEnv = g.getEnvelopeInternal();
        Assert.assertTrue((boolean)smoothEnv.covers(inEnv));
    }
}

