/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.temporal.After;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.filter.visitor.AbstractPostPreProcessFilterSplittingVisitorTests;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PostPreProcessFilterSplittingVisitorTest
extends AbstractPostPreProcessFilterSplittingVisitorTests {
    private FilterCapabilities simpleLogicalCaps = new FilterCapabilities();
    private PostPreProcessFilterSplittingVisitor visitor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.simpleLogicalCaps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        this.simpleLogicalCaps.addAll(FilterCapabilities.LOGICAL_OPENGIS);
    }

    @Test
    public void testVisitBetweenFilter() throws Exception {
        PropertyIsBetween filter = this.ff.between((Expression)this.ff.literal(0), (Expression)this.ff.property("num"), (Expression)this.ff.literal(4));
        FilterCapabilities caps = new FilterCapabilities(PropertyIsBetween.class);
        this.runTest((Filter)filter, caps, "num");
    }

    @Test
    public void testNullTransactionAccessor() throws Exception {
        this.accessor = null;
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.and((Filter)f1, (Filter)f2), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalANDFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.and((Filter)f1, (Filter)f2), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalNOTFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)this.ff.not((Filter)f1), this.simpleLogicalCaps, "name");
    }

    @Test
    public void testVisitLogicalORFilter() throws Exception {
        PropertyIsEqualTo f1 = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo f2 = this.createPropertyIsEqualToFilter("name", "jose");
        Or orFilter = this.ff.or((Filter)f1, (Filter)f2);
        this.runTest((Filter)orFilter, this.simpleLogicalCaps, "name");
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        f2 = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        orFilter = this.ff.or((Filter)f1, (Filter)f2);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
    }

    @Test
    public void testMassOrFilter() throws Exception {
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        for (int i = 0; i < 10000; ++i) {
            filters.add(this.ff.equals((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)("" + i))));
        }
        Or orFilter = this.ff.or(filters);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
    }

    @Test
    public void testVisitCompareFilter() throws Exception {
        PropertyIsEqualTo f = this.createPropertyIsEqualToFilter("name", "david");
        this.runTest((Filter)f, FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS, "name");
    }

    @Test
    public void testVisitCompareFilterWithUpdateDifferentAttribute() throws Exception {
        PropertyIsEqualTo f = this.createPropertyIsEqualToFilter("name", "david");
        PropertyIsEqualTo updateFilter = this.createPropertyIsEqualToFilter("name", "jose");
        this.accessor = new AbstractPostPreProcessFilterSplittingVisitorTests.TestAccessor(this);
        this.accessor.setUpdate("geom", (Filter)updateFilter);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((String)this.visitor.getFilterPost().toString(), (Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((String)this.visitor.getFilterPre().toString(), (Object)f, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testVisitLikeFilter() throws Exception {
        PropertyIsLike filter = this.ff.like((Expression)this.ff.property("name"), "j*", "*", "?", "\\");
        FilterCapabilities likeCaps = new FilterCapabilities(PropertyIsLike.class);
        this.runTest((Filter)filter, likeCaps, "name");
    }

    @Test
    public void testVisitNullFilter() throws Exception {
        PropertyIsNull filter = this.ff.isNull((Expression)this.ff.property("name"));
        FilterCapabilities nullCaps = new FilterCapabilities(PropertyIsNull.class);
        this.runTest((Filter)filter, nullCaps, "name");
    }

    @Test
    public void testVisitFidFilter() throws Exception {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("david"));
        Id filter = this.ff.id(ids);
        this.visitor = this.newVisitor(new FilterCapabilities(Id.class));
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testVisitIdFilterWithNoIdCapabilities() throws Exception {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("david"));
        Id idFilter = this.ff.id(ids);
        FilterCapabilities fc = new FilterCapabilities();
        fc.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        fc.addType(And.class);
        this.visitor = this.newVisitor(fc);
        idFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)idFilter, (Object)this.visitor.getFilterPost());
    }

    @Test
    public void testFunctionFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo filter = this.createFunctionFilter();
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        filter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)filter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionANDGeometryFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        And andFilter = this.ff.and((Filter)funtionFilter, (Filter)geomFilter);
        andFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)funtionFilter.toString(), (Object)this.visitor.getFilterPost().toString());
        Assert.assertEquals((Object)geomFilter.toString(), (Object)this.visitor.getFilterPre().toString());
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        andFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)andFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionORGeometryFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        Or orFilter = this.ff.or((Filter)funtionFilter, (Filter)geomFilter);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testFunctionNOTFilter() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        Not not = this.ff.not((Filter)funtionFilter);
        not.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)not, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        not.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)not, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testNullParentNullAccessor() throws Exception {
        this.simpleLogicalCaps.addType(BBOX.class);
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = this.newVisitor(this.simpleLogicalCaps);
        PropertyIsEqualTo funtionFilter = this.createFunctionFilter();
        BBOX geomFilter = this.ff.bbox("geom", 10.0, 20.0, 10.0, 20.0, "");
        Or orFilter = this.ff.or((Filter)funtionFilter, (Filter)geomFilter);
        this.visitor = new PostPreProcessFilterSplittingVisitor(new FilterCapabilities(), null, null);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPost());
        this.visitor = new PostPreProcessFilterSplittingVisitor(this.simpleLogicalCaps, null, null);
        orFilter.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)orFilter, (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testComplicatedOrFilter() throws Exception {
        PropertyIsEqualTo c1 = this.ff.equals((Expression)this.ff.property("eventstatus"), (Expression)this.ff.literal((Object)"deleted"));
        PropertyIsEqualTo c2 = this.ff.equals((Expression)this.ff.property("eventtype"), (Expression)this.ff.literal((Object)"road hazard"));
        PropertyIsEqualTo c3 = this.ff.equals((Expression)this.ff.property("eventtype"), (Expression)this.ff.literal((Object)"area warning"));
        BBOX g = this.ff.bbox("geom", 0.0, 180.0, 0.0, 90.0, "");
        Or f = this.ff.or((Filter)c2, (Filter)c3);
        f = this.ff.and((Filter)this.ff.not((Filter)c1), (Filter)f);
        f = this.ff.and((Filter)f, (Filter)g);
        this.simpleLogicalCaps.addType(BBOX.class);
        this.simpleLogicalCaps.addType(FilterFunction_geometryType.class);
        this.visitor = new PostPreProcessFilterSplittingVisitor(this.simpleLogicalCaps, null, null);
        f.accept((FilterVisitor)this.visitor, null);
        Assert.assertEquals((Object)f, (Object)this.visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)this.visitor.getFilterPost());
        this.visitor = new PostPreProcessFilterSplittingVisitor(this.simpleLogicalCaps, null, new ClientTransactionAccessor(){

            public Filter getDeleteFilter() {
                return null;
            }

            public Filter getUpdateFilter(String attributePath) {
                if (attributePath.equals("eventtype")) {
                    HashSet<FeatureId> ids = new HashSet<FeatureId>();
                    ids.add(PostPreProcessFilterSplittingVisitorTest.this.ff.featureId("fid"));
                    return PostPreProcessFilterSplittingVisitorTest.this.ff.id(ids);
                }
                return null;
            }
        });
        f.accept((FilterVisitor)this.visitor, null);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("fid"));
        Assert.assertEquals((Object)f, (Object)this.visitor.getFilterPost());
        Assert.assertEquals((Object)this.ff.or((Filter)f, (Filter)this.ff.id(ids)), (Object)this.visitor.getFilterPre());
    }

    @Test
    public void testOrNotSupported() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        caps.addType(And.class);
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f1 = ff.equals((Expression)ff.property("CFCC"), (Expression)ff.literal((Object)"A41"));
        PropertyIsEqualTo f2 = ff.equals((Expression)ff.property("CFCC"), (Expression)ff.literal((Object)"A42"));
        Or ored = ff.or((Filter)f1, (Filter)f2);
        ored.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPre());
        Assert.assertEquals((Object)ored, (Object)visitor.getFilterPost());
        And anded = ff.and((Filter)f1, (Filter)f2);
        visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        anded.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)anded, (Object)visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPost());
    }

    @Test
    public void testTemporalFilter() throws Exception {
        FilterCapabilities caps = new FilterCapabilities();
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        After f1 = this.ff.after((Expression)this.ff.property("foo"), (Expression)this.ff.literal((Object)"2011-06-20"));
        f1.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)f1, (Object)visitor.getFilterPost());
    }

    @Test
    public void testIsNullFilter() {
        FilterCapabilities caps = new FilterCapabilities();
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        caps.addType(PropertyIsNull.class);
        PropertyIsNull f1 = this.ff.isNull((Expression)this.ff.literal((Object)"abc"));
        f1.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)f1, (Object)visitor.getFilterPre());
        visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        PropertyIsNull f2 = this.ff.isNull((Expression)this.ff.function("strConcat", new Expression[]{this.ff.literal((Object)"abc"), this.ff.literal((Object)"def")}));
        f2.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)f2, (Object)visitor.getFilterPost());
    }

    @Test
    public void testNullLiteralInLogicCombination() {
        FilterCapabilities caps = new FilterCapabilities();
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        caps.addType(And.class);
        caps.addType(Or.class);
        caps.addType(Not.class);
        PropertyIsEqualTo f1 = this.ff.equal((Expression)this.ff.literal(null), (Expression)this.ff.literal((Object)"test"), false);
        Not f2 = this.ff.not((Filter)this.ff.equal((Expression)this.ff.literal(null), (Expression)this.ff.literal((Object)"test"), false));
        Or or = this.ff.or(Arrays.asList(f1, f2));
        or.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)or, (Object)visitor.getFilterPre());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)visitor.getFilterPost());
    }

    @Test
    public void testIndexOutOfBoundExceptionNotHappensWithTwoInMemoryFilter() {
        FilterCapabilities caps = new FilterCapabilities();
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(caps, null, null);
        caps.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        caps.addType(JsonPointerFunction.class);
        caps.addType(And.class);
        Crosses memoryOne = this.ff.crosses((String)null, null);
        Crosses memoryTwo = this.ff.crosses((String)null, null);
        PropertyIsEqualTo otherFilter = this.ff.equal((Expression)this.ff.function("jsonPointer", new Expression[]{this.ff.literal((Object)"/pointer"), this.ff.property("property")}), (Expression)this.ff.literal((Object)"test"), false);
        And and = this.ff.and(Arrays.asList(memoryOne, memoryTwo, otherFilter));
        and.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)this.ff.and(Arrays.asList(memoryOne, memoryTwo)), (Object)visitor.getFilterPost());
        Assert.assertEquals((Object)otherFilter, (Object)visitor.getFilterPre());
    }
}

