/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BBOX3D;
import org.geotools.api.geometry.BoundingBox3D;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCRSFilterVisitorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    @Test
    public void force3DCRS2DEnvelope() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode("EPSG:4939", true);
        SingleCRS hcrs = CRS.getHorizontalCRS(crs);
        BBOX bbox = this.ff.bbox("the_geom", -180.0, -90.0, 180.0, 90.0, null);
        DefaultCRSFilterVisitor visitor = new DefaultCRSFilterVisitor(this.ff, crs);
        BBOX filtered = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        Literal box = (Literal)filtered.getExpression2();
        ReferencedEnvelope re = (ReferencedEnvelope)box.evaluate(null);
        Assert.assertEquals((Object)hcrs, (Object)re.getCoordinateReferenceSystem());
    }

    @Test
    public void force3DCRS3DEnvelope() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode("EPSG:4939", true);
        BBOX3D bbox = this.ff.bbox((Expression)this.ff.property("the_geom"), (BoundingBox3D)new ReferencedEnvelope3D(-180.0, 180.0, -90.0, 90.0, 0.0, 100.0, null));
        DefaultCRSFilterVisitor visitor = new DefaultCRSFilterVisitor(this.ff, crs);
        BBOX filtered = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        Literal box = (Literal)filtered.getExpression2();
        ReferencedEnvelope re = (ReferencedEnvelope)box.evaluate(null);
        Assert.assertEquals((Object)crs, (Object)re.getCoordinateReferenceSystem());
    }
}

