/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.color.HSLColor;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;

public class ColorFunctionsTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testSaturateAbsolute() {
        Function function = FF.function("saturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"20%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80FF00", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testSaturateAbsoluteOvershoot() {
        Function function = FF.function("saturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"80%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80FF00", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testSaturateRelative() {
        Function function = FF.function("saturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"10%"), FF.literal((Object)"relative")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80F00F", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testDesaturateAbsolute() {
        Function function = FF.function("desaturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"20%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80CC33", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testDesaturateAbsoluteOvershoot() {
        Function function = FF.function("desaturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"90%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#808080", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testDesaturateRelative() {
        Function function = FF.function("desaturate", new Expression[]{FF.literal((Object)"#80e619"), FF.literal((Object)"10%"), FF.literal((Object)"relative")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80DC23", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testDarken() {
        Function function = FF.function("darken", new Expression[]{FF.literal((Object)"#3cb878"), FF.literal((Object)"30%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#16452D", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testLighten() {
        Function function = FF.function("lighten", new Expression[]{FF.literal((Object)"#3cb878"), FF.literal((Object)"30%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#AAE3C6", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testMix() {
        Function function = FF.function("mix", new Expression[]{FF.literal((Object)"#ff0000"), FF.literal((Object)"#0000ff"), FF.literal((Object)"50%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#800080", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testTint() {
        Function function = FF.function("tint", new Expression[]{FF.literal((Object)"#007fff"), FF.literal((Object)"50%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80BFFF", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testShade() {
        Function function = FF.function("shade", new Expression[]{FF.literal((Object)"#007fff"), FF.literal((Object)"50%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#004080", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testSpin() {
        Color color = new HSLColor(10.0, 0.9, 0.5).toRGB();
        Function function = FF.function("spin", new Expression[]{FF.literal((Object)color), FF.literal(30)});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#F2A60D", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testSpinBackwards() {
        Color color = new HSLColor(10.0, 0.9, 0.5).toRGB();
        Function function = FF.function("spin", new Expression[]{FF.literal((Object)color), FF.literal(-30)});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#F20D5A", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testGrayscale() {
        Function function = FF.function("grayscale", new Expression[]{FF.literal((Object)"#ff0000")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#808080", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testContrastNoLightDark() {
        Function function = FF.function("contrast", new Expression[]{FF.literal((Object)"#bbbbbb")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#000000", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testContrastDarkReference() {
        Function function = FF.function("contrast", new Expression[]{FF.literal((Object)"#222222"), FF.literal((Object)"#101010")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#FFFFFF", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testContrastDarkLigthReference() {
        Function function = FF.function("contrast", new Expression[]{FF.literal((Object)"#222222"), FF.literal((Object)"#101010"), FF.literal((Object)"#dddddd")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#DDDDDD", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testContrastLowThreshold() {
        Color color = new HSLColor(90.0, 1.0, 0.5).toRGB();
        Function function = FF.function("contrast", new Expression[]{FF.literal((Object)color), FF.literal((Object)"#000000"), FF.literal((Object)"#ffffff"), FF.literal((Object)"30%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#000000", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testContrastHighThreshold() {
        Color color = new HSLColor(90.0, 1.0, 0.5).toRGB();
        Function function = FF.function("contrast", new Expression[]{FF.literal((Object)color), FF.literal((Object)"#000000"), FF.literal((Object)"#ffffff"), FF.literal((Object)"80%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#FFFFFF", (Object)Converters.convert((Object)result, String.class));
    }

    @Test
    public void testHslFunction() {
        Function function = FF.function("hsl", new Expression[]{FF.literal(90), FF.literal((Object)"100%"), FF.literal((Object)"50%")});
        Color result = (Color)function.evaluate(null);
        Assert.assertEquals((Object)"#80FF00", (Object)Converters.convert((Object)result, String.class));
    }
}

