/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.ClippedFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ClippedFeatureCollectionTest {
    DefaultFeatureCollection delegatePolygonZ;
    DefaultFeatureCollection delegateMultiLineZ;
    DefaultFeatureCollection delegateLineZ;
    DefaultFeatureCollection delegateGeom;

    @Before
    public void setUp() throws Exception {
        WKTReader reader = new WKTReader();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("Polygons3D");
        tb.add("geom", Polygon.class);
        tb.add("name", String.class);
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.delegatePolygonZ = new DefaultFeatureCollection(null, featureType);
        SimpleFeatureBuilder bPoly = new SimpleFeatureBuilder(featureType);
        Geometry poly1 = reader.read("POLYGON((0 0 0, 0 10000 2, 10000 10000 2, 10000 0 0, 0 0 0))");
        bPoly.add((Object)poly1);
        bPoly.add((Object)"one");
        this.delegatePolygonZ.add(bPoly.buildFeature("fid.1"));
        bPoly.reset();
        Geometry poly2 = reader.read("POLYGON((0 0, 0 5000, 5000 5000, 5000 0, 0 0))");
        bPoly.add((Object)poly2);
        bPoly.add((Object)"two");
        this.delegatePolygonZ.add(bPoly.buildFeature("fid.2"));
        SimpleFeatureTypeBuilder tbML = new SimpleFeatureTypeBuilder();
        tbML.setName("MultiLines");
        tbML.add("geom", MultiLineString.class);
        tbML.add("name", String.class);
        SimpleFeatureType featureTypeML = tbML.buildFeatureType();
        this.delegateMultiLineZ = new DefaultFeatureCollection(null, featureTypeML);
        SimpleFeatureBuilder bML = new SimpleFeatureBuilder(featureTypeML);
        Geometry multiline = reader.read("MULTILINESTRING((1000 0 0, 1000 1000 1, 2000 1000 2, 2000 0 3), (1000 3000 0, 1000 2000 1, 2000 2000 2, 2000 3000 3))");
        bML.add((Object)multiline);
        bML.add((Object)"one");
        this.delegateMultiLineZ.add(bML.buildFeature("fid.1"));
        SimpleFeatureTypeBuilder tbL = new SimpleFeatureTypeBuilder();
        tbL.setName("Lines");
        tbL.add("geom", LineString.class);
        tbL.add("name", String.class);
        SimpleFeatureType featureTypeL = tbL.buildFeatureType();
        this.delegateLineZ = new DefaultFeatureCollection(null, featureTypeL);
        SimpleFeatureBuilder bL = new SimpleFeatureBuilder(featureTypeL);
        Geometry line = reader.read("LINESTRING(0 0 0, 10000 0 1, 10000 10000 2)");
        bL.add((Object)line);
        bL.add((Object)"one");
        this.delegateLineZ.add(bL.buildFeature("fid.1"));
        SimpleFeatureTypeBuilder tbG = new SimpleFeatureTypeBuilder();
        tbG.setName("Geometries");
        tbG.add("geom", Geometry.class);
        tbG.add("name", String.class);
        SimpleFeatureType featureTypeG = tbG.buildFeatureType();
        this.delegateGeom = new DefaultFeatureCollection(null, featureTypeG);
        SimpleFeatureBuilder bG = new SimpleFeatureBuilder(featureTypeG);
        bG.add((Object)poly1);
        bG.add((Object)"one");
        this.delegateGeom.add(bG.buildFeature("fid.1"));
        bG.add((Object)multiline);
        bG.add((Object)"two");
        this.delegateGeom.add(bG.buildFeature("fid.2"));
        bG.add((Object)line);
        bG.add((Object)"three");
        this.delegateGeom.add(bG.buildFeature("fid.3"));
    }

    @Test
    public void testClipPolygon() throws ParseException {
        Geometry clip = new WKTReader().read("POLYGON((-10 -10, -10 10010, 10010 10010, 10010 -10, -10 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegatePolygonZ, clip, true);
        this.assertSquaresMetersIdentical((SimpleFeatureCollection)collection);
    }

    @Test
    public void testClipPoly3DOnBorder() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((0 0, 0 10000, 10000 10000, 10000 0, 0 0))");
        ClippedFeatureCollection result = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegatePolygonZ, clip, true);
        Assert.assertEquals((long)2L, (long)result.size());
        this.assertSquaresMetersIdentical((SimpleFeatureCollection)result);
    }

    @Test
    public void testClipPoly3DNewVertices() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((0 5000, 0 10000, 10000 10000, 10000 5000, 0 5000))");
        ClippedFeatureCollection result = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegatePolygonZ, clip, true);
        Assert.assertEquals((long)1L, (long)result.size());
        try (SimpleFeatureIterator fi = result.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiPolygon mp = (MultiPolygon)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)mp.getNumGeometries());
            Polygon p = (Polygon)mp.getGeometryN(0);
            Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
            LinearRing shell = p.getExteriorRing();
            CoordinateSequence cs = shell.getCoordinateSequence();
            Assert.assertEquals((long)5L, (long)cs.size());
            this.assertOrdinates(0.0, 5000.0, 1.0, cs, 0);
            this.assertOrdinates(0.0, 10000.0, 2.0, cs, 1);
            this.assertOrdinates(10000.0, 10000.0, 2.0, cs, 2);
            this.assertOrdinates(10000.0, 5000.0, 1.0, cs, 3);
            this.assertOrdinates(0.0, 5000.0, 1.0, cs, 4);
            Assert.assertFalse((boolean)fi.hasNext());
        }
    }

    @Test
    public void testClipPoly3DFullyInside() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((2500 2500, 2500 7500, 7500 7500, 7500 2500, 2500 2500))");
        ClippedFeatureCollection result = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegatePolygonZ, clip, true);
        Assert.assertEquals((long)2L, (long)result.size());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)result);
        MultiPolygon mp = (MultiPolygon)f.getDefaultGeometry();
        Assert.assertEquals((long)1L, (long)mp.getNumGeometries());
        Polygon p = (Polygon)mp.getGeometryN(0);
        Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
        LinearRing shell = p.getExteriorRing();
        CoordinateSequence cs = shell.getCoordinateSequence();
        Assert.assertEquals((long)5L, (long)cs.size());
        this.assertOrdinates(2500.0, 2500.0, 0.411765, cs, 0);
        this.assertOrdinates(2500.0, 7500.0, 1.588235, cs, 1);
        this.assertOrdinates(7500.0, 7500.0, 1.588235, cs, 2);
        this.assertOrdinates(7500.0, 2500.0, 0.411765, cs, 3);
        this.assertOrdinates(2500.0, 2500.0, 0.411765, cs, 4);
    }

    @Test
    public void testClipMultiLine() throws ParseException {
        Geometry clip = new WKTReader().read("POLYGON((900 900, 900 2100, 2100 2100, 2100 900, 900 900))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateMultiLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)collection);
        MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
        Assert.assertEquals((long)2L, (long)ml.getNumGeometries());
        LineString ls = (LineString)ml.getGeometryN(0);
        CoordinateSequence cs = ls.getCoordinateSequence();
        Assert.assertEquals((long)4L, (long)cs.size());
        this.assertOrdinates(1000.0, 900.0, 0.9, cs, 0);
        this.assertOrdinates(1000.0, 1000.0, 1.0, cs, 1);
        this.assertOrdinates(2000.0, 1000.0, 2.0, cs, 2);
        this.assertOrdinates(2000.0, 900.0, 2.1, cs, 3);
        ls = (LineString)ml.getGeometryN(1);
        cs = ls.getCoordinateSequence();
        Assert.assertEquals((long)4L, (long)cs.size());
        this.assertOrdinates(1000.0, 2100.0, 0.9, cs, 0);
        this.assertOrdinates(1000.0, 2000.0, 1.0, cs, 1);
        this.assertOrdinates(2000.0, 2000.0, 2.0, cs, 2);
        this.assertOrdinates(2000.0, 2100.0, 2.1, cs, 3);
    }

    @Test
    public void testClipLine3DIncluded() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((-10 -10, -10 10010, 10010 10010, 10010 -10, -10 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        try (SimpleFeatureIterator fi = collection.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)ml.getNumGeometries());
            LineString ls = (LineString)ml.getGeometryN(0);
            CoordinateSequence cs = ls.getCoordinateSequence();
            Assert.assertEquals((long)3L, (long)cs.size());
            this.assertOrdinates(0.0, 0.0, 0.0, cs, 0);
            this.assertOrdinates(10000.0, 0.0, 1.0, cs, 1);
            this.assertOrdinates(10000.0, 10000.0, 2.0, cs, 2);
        }
    }

    @Test
    public void testClipLine3DMidFirstSegment() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((-10 -10, -10 10, 5000 10, 5000 -10, -10 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        try (SimpleFeatureIterator fi = collection.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)ml.getNumGeometries());
            LineString ls = (LineString)ml.getGeometryN(0);
            CoordinateSequence cs = ls.getCoordinateSequence();
            Assert.assertEquals((long)2L, (long)cs.size());
            this.assertOrdinates(0.0, 0.0, 0.0, cs, 0);
            this.assertOrdinates(5000.0, 0.0, 0.5, cs, 1);
        }
    }

    @Test
    public void testClipExtractBend() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((5000 -10, 5000 5000, 11000 5000, 11000 -10, 5000 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        try (SimpleFeatureIterator fi = collection.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)ml.getNumGeometries());
            LineString ls = (LineString)ml.getGeometryN(0);
            CoordinateSequence cs = ls.getCoordinateSequence();
            Assert.assertEquals((long)3L, (long)cs.size());
            this.assertOrdinates(5000.0, 0.0, 0.5, cs, 0);
            this.assertOrdinates(10000.0, 0.0, 1.0, cs, 1);
            this.assertOrdinates(10000.0, 5000.0, 1.5, cs, 2);
        }
    }

    @Test
    public void testClipExtractSeparateBitsLowLine() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((1000 -10, 1000 10, 9000 10, 9000 -10, 8000 -10, 8000 5, 2000 5, 2000 -10, 1000 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        try (SimpleFeatureIterator fi = collection.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
            Assert.assertEquals((long)2L, (long)ml.getNumGeometries());
            LineString ls = (LineString)ml.getGeometryN(0);
            CoordinateSequence cs = ls.getCoordinateSequence();
            Assert.assertEquals((long)2L, (long)cs.size());
            this.assertOrdinates(1000.0, 0.0, 0.1, cs, 0);
            this.assertOrdinates(2000.0, 0.0, 0.2, cs, 1);
            ls = (LineString)ml.getGeometryN(1);
            cs = ls.getCoordinateSequence();
            Assert.assertEquals((long)2L, (long)cs.size());
            this.assertOrdinates(8000.0, 0.0, 0.8, cs, 0);
            this.assertOrdinates(9000.0, 0.0, 0.9, cs, 1);
        }
    }

    @Test
    public void testClipExtractSeparateBitsBothLines() throws Exception {
        Geometry clip = new WKTReader().read("POLYGON((1000 -10, 1000 5000, 11000 5000, 11000 4000, 2000 4000, 2000 -10, 1000 -10))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateLineZ, clip, true);
        Assert.assertEquals((long)1L, (long)collection.size());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)collection);
        MultiLineString ml = (MultiLineString)f.getDefaultGeometry();
        Assert.assertEquals((long)2L, (long)ml.getNumGeometries());
        LineString ls = (LineString)ml.getGeometryN(0);
        CoordinateSequence cs = ls.getCoordinateSequence();
        Assert.assertEquals((long)2L, (long)cs.size());
        this.assertOrdinates(1000.0, 0.0, 0.1, cs, 0);
        this.assertOrdinates(2000.0, 0.0, 0.2, cs, 1);
        ls = (LineString)ml.getGeometryN(1);
        cs = ls.getCoordinateSequence();
        Assert.assertEquals((long)2L, (long)cs.size());
        this.assertOrdinates(10000.0, 4000.0, 1.4, cs, 0);
        this.assertOrdinates(10000.0, 5000.0, 1.5, cs, 1);
    }

    private void assertSquaresMetersIdentical(SimpleFeatureCollection result) {
        try (SimpleFeatureIterator fi = result.features();){
            SimpleFeature f = (SimpleFeature)fi.next();
            MultiPolygon mp = (MultiPolygon)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)mp.getNumGeometries());
            Polygon p = (Polygon)mp.getGeometryN(0);
            Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
            LinearRing shell = p.getExteriorRing();
            CoordinateSequence cs = shell.getCoordinateSequence();
            Assert.assertEquals((long)5L, (long)cs.size());
            this.assertOrdinates(0.0, 0.0, 0.0, cs, 0);
            this.assertOrdinates(0.0, 10000.0, 2.0, cs, 1);
            this.assertOrdinates(10000.0, 10000.0, 2.0, cs, 2);
            this.assertOrdinates(10000.0, 0.0, 0.0, cs, 3);
            this.assertOrdinates(0.0, 0.0, 0.0, cs, 4);
            f = (SimpleFeature)fi.next();
            mp = (MultiPolygon)f.getDefaultGeometry();
            Assert.assertEquals((long)1L, (long)mp.getNumGeometries());
            p = (Polygon)mp.getGeometryN(0);
            Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
            shell = p.getExteriorRing();
            cs = shell.getCoordinateSequence();
            Assert.assertEquals((long)5L, (long)cs.size());
            this.assertOrdinates(0.0, 0.0, Double.NaN, cs, 0);
            this.assertOrdinates(0.0, 5000.0, Double.NaN, cs, 1);
            this.assertOrdinates(5000.0, 5000.0, Double.NaN, cs, 2);
            this.assertOrdinates(5000.0, 0.0, Double.NaN, cs, 3);
            this.assertOrdinates(0.0, 0.0, Double.NaN, cs, 4);
        }
    }

    @Test
    public void testClipGeometry() throws Exception {
        WKTReader reader = new WKTReader();
        Geometry clip = reader.read("POLYGON((0 0, 0 2500, 2500 2500, 2500 0, 0 0))");
        ClippedFeatureCollection collection = new ClippedFeatureCollection((SimpleFeatureCollection)this.delegateGeom, clip, false);
        Assert.assertEquals((long)3L, (long)collection.size());
        List features = DataUtilities.list((FeatureCollection)collection);
        SimpleFeature f0 = (SimpleFeature)features.get(0);
        Assert.assertEquals((Object)"one", (Object)f0.getAttribute("name"));
        Assert.assertEquals((Object)clip, (Object)f0.getDefaultGeometry());
        SimpleFeature f1 = (SimpleFeature)features.get(1);
        Assert.assertEquals((Object)"two", (Object)f1.getAttribute("name"));
        Geometry expectedMultiLine = reader.read("MULTILINESTRING((1000 0, 1000 1000, 2000 1000, 2000 0), (1000 2500, 1000 2000, 2000 2000, 2000 2500))");
        Assert.assertEquals((Object)expectedMultiLine, (Object)f1.getDefaultGeometry());
        SimpleFeature f2 = (SimpleFeature)features.get(2);
        Assert.assertEquals((Object)"three", (Object)f2.getAttribute("name"));
        Geometry expectedLine = reader.read("LINESTRING(0 0, 2500 0)");
        Assert.assertEquals((Object)expectedLine, (Object)f2.getDefaultGeometry());
    }

    private void assertOrdinates(double x, double y, double z, CoordinateSequence cs, int index) {
        Assert.assertEquals((double)x, (double)cs.getOrdinate(index, 0), (double)0.0);
        Assert.assertEquals((double)y, (double)cs.getOrdinate(index, 1), (double)0.0);
        double otherZ = cs.getOrdinate(index, 2);
        if (Double.isNaN(z)) {
            Assert.assertTrue((boolean)Double.isNaN(otherZ));
        } else {
            Assert.assertEquals((double)z, (double)otherZ, (double)0.0);
        }
    }
}

