/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.junit.Before;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public abstract class FeatureCollectionWrapperTestSupport {
    protected static final String TEST_VALUE = "test_value";
    protected static final String TEST_KEY = "test_key";
    protected CoordinateReferenceSystem crs;
    protected DefaultFeatureCollection delegate;

    @Before
    public void setUp() throws Exception {
        this.crs = CRS.parseWKT("GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.setNamespaceURI("test");
        typeBuilder.setCRS(this.crs);
        typeBuilder.add("defaultGeom", Point.class, this.crs);
        typeBuilder.add("someAtt", Integer.class);
        typeBuilder.add("otherGeom", LineString.class);
        typeBuilder.setDefaultGeometry("defaultGeom");
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryFactory gf = new GeometryFactory();
        this.delegate = new DefaultFeatureCollection("test", featureType){};
        double x = -140.0;
        double y = 45.0;
        int features = 5;
        for (int i = 0; i < 5; ++i) {
            Point point = gf.createPoint(new Coordinate(x + (double)i, y + (double)i));
            point.setUserData((Object)this.crs);
            builder.add((Object)point);
            builder.add((Object)i);
            LineString line = gf.createLineString(new Coordinate[]{new Coordinate(x + (double)i, y + (double)i), new Coordinate(x + (double)i + 1.0, y + (double)i + 1.0)});
            line.setUserData((Object)this.crs);
            builder.add((Object)line);
            builder.featureUserData((Object)TEST_KEY, (Object)TEST_VALUE);
            this.delegate.add(builder.buildFeature("" + i));
        }
        builder.add(null);
        builder.add((Object)-1);
        builder.add(null);
        this.delegate.add(builder.buildFeature("6"));
    }
}

