/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.List;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.type.Name;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.data.store.DiffTransactionState;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;

public class ContentEntryTest {
    @Test
    public void transactionCacheClearedOnTransactionClose() {
        ContentDataStore dataStore = new ContentDataStore(){

            protected List<Name> createTypeNames() throws IOException {
                return null;
            }

            protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
                return null;
            }
        };
        DefaultTransaction transaction = new DefaultTransaction();
        ContentEntry entry = new ContentEntry(dataStore, (Name)new NameImpl("test"));
        ContentState state = entry.getState((Transaction)transaction);
        new DiffTransactionState(state);
        Assert.assertSame((Object)state, (Object)entry.getState((Transaction)transaction));
        Assert.assertSame((Object)state.getTransaction(), (Object)transaction);
        try {
            transaction.close();
            ContentState stateForClosedTransaction = entry.getState((Transaction)transaction);
            Assert.assertNotSame((Object)stateForClosedTransaction, (Object)state);
        }
        catch (IOException e) {
            Assert.fail((String)("Cannot close transaction: " + e.getLocalizedMessage()));
        }
    }
}

