/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureWriter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;

public abstract class AbstractContentTest {
    protected static final Name TYPENAME = new NameImpl("http://www.geotools.org", "Mock");
    protected static final SimpleFeatureType TYPE = AbstractContentTest.buildType();
    List<SimpleFeature> FEATURES = Stream.of(AbstractContentTest.buildFeature("mock.3"), AbstractContentTest.buildFeature("mock.1"), AbstractContentTest.buildFeature("mock.2")).collect(Collectors.toList());

    protected static SimpleFeatureType buildType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(TYPENAME);
        builder.add("geom", LineString.class);
        return builder.buildFeatureType();
    }

    protected static SimpleFeature buildFeature(String id) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(TYPE);
        builder.add((Object)new Envelope(0.0, 1.0, 0.0, 1.0));
        return builder.buildFeature(id);
    }

    protected class MockSimpleFeatureWriter
    implements SimpleFeatureWriter {
        private int index = 0;
        SimpleFeature newFeature;

        protected MockSimpleFeatureWriter() {
        }

        public SimpleFeatureType getFeatureType() {
            return TYPE;
        }

        public SimpleFeature next() throws IOException {
            if (this.index >= AbstractContentTest.this.FEATURES.size()) {
                this.newFeature = AbstractContentTest.buildFeature("mock." + ++this.index);
                return this.newFeature;
            }
            return AbstractContentTest.this.FEATURES.get(this.index++);
        }

        public void remove() throws IOException {
            if (this.index > 0 && this.index <= AbstractContentTest.this.FEATURES.size()) {
                AbstractContentTest.this.FEATURES.remove(this.index - 1);
            }
        }

        public void write() throws IOException {
            if (this.index > AbstractContentTest.this.FEATURES.size()) {
                AbstractContentTest.this.FEATURES.add(this.newFeature);
            }
        }

        public boolean hasNext() throws IOException {
            return this.index < AbstractContentTest.this.FEATURES.size();
        }

        public void close() throws IOException {
        }
    }

    protected class MockSimpleFeatureReader
    implements SimpleFeatureReader {
        private int index = 0;

        protected MockSimpleFeatureReader() {
        }

        public SimpleFeatureType getFeatureType() {
            return TYPE;
        }

        public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
            return AbstractContentTest.this.FEATURES.get(this.index++);
        }

        public boolean hasNext() throws IOException {
            return this.index < AbstractContentTest.this.FEATURES.size();
        }

        public void close() throws IOException {
        }
    }

    protected class MockContentFeatureStore
    extends ContentFeatureStore {
        public MockContentFeatureStore(ContentEntry entry, Query query) {
            super(entry, query);
        }

        protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected int getCountInternal(Query query) throws IOException {
            if (query.getFilter() == Filter.INCLUDE) {
                int count = 0;
                try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
                    while (featureReader.hasNext()) {
                        featureReader.next();
                        ++count;
                    }
                }
                return count;
            }
            return -1;
        }

        protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
            return new MockSimpleFeatureReader();
        }

        protected SimpleFeatureType buildFeatureType() throws IOException {
            return TYPE;
        }

        protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
            return new MockSimpleFeatureWriter();
        }
    }

    protected class MockContentDataStore
    extends ContentDataStore {
        protected MockContentDataStore() {
            this.namespaceURI = TYPE.getName().getNamespaceURI();
        }

        protected List<Name> createTypeNames() throws IOException {
            return List.of(TYPENAME);
        }

        protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
            return new MockContentFeatureStore(entry, null);
        }
    }
}

