/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.TestReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class DiffWriterTest {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    DiffFeatureWriter writer;
    private Point geom;
    private SimpleFeatureType type;

    @Before
    public void setUp() throws Exception {
        this.type = DataUtilities.createType((String)"default", (String)"name:String,*geom:Geometry");
        GeometryFactory fac = new GeometryFactory();
        this.geom = fac.createPoint(new Coordinate(10.0, 10.0));
        Diff diff = new Diff();
        diff.add("1", SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"diff1", this.geom}, (String)"1"));
        diff.modify("original", SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"diff2", this.geom}, (String)"original"));
        this.reader = new TestReader(this.type, SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"original", this.geom}, (String)"original"));
        this.writer = new DiffFeatureWriter(this.reader, diff){

            protected void fireNotification(int eventType, ReferencedEnvelope bounds) {
            }
        };
    }

    @After
    public void cleanup() throws IOException {
        this.writer.close();
        this.reader.close();
    }

    @Test
    public void testRemove() throws Exception {
        this.writer.next();
        SimpleFeature feature = this.writer.next();
        this.writer.remove();
        Assert.assertNull(this.writer.diff.getAdded().get(feature.getID()));
    }

    @Test
    public void testHasNext() throws Exception {
        Assert.assertTrue((boolean)this.writer.hasNext());
        Assert.assertEquals((long)2L, (long)(this.writer.diff.getAdded().size() + this.writer.diff.getModified().size()));
        this.writer.next();
        Assert.assertTrue((boolean)this.writer.hasNext());
        Assert.assertEquals((long)2L, (long)(this.writer.diff.getAdded().size() + this.writer.diff.getModified().size()));
        this.writer.next();
        Assert.assertFalse((boolean)this.writer.hasNext());
        Assert.assertEquals((long)2L, (long)(this.writer.diff.getAdded().size() + this.writer.diff.getModified().size()));
    }

    @Test
    public void testWrite() throws IOException, Exception {
        while (this.writer.hasNext()) {
            this.writer.next();
        }
        SimpleFeature feature = this.writer.next();
        feature.setAttribute("name", (Object)"new1");
        this.writer.write();
        Assert.assertEquals((long)2L, (long)this.writer.diff.getAdded().size());
        feature = this.writer.next();
        feature.setAttribute("name", (Object)"new2");
        this.writer.write();
        Assert.assertEquals((long)3L, (long)this.writer.diff.getAdded().size());
    }
}

