/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfGraphics2D;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;

public class PDFMaxSizeEnforcer {
    long maxSize;
    ByteBuffer pdfBytes;

    public PDFMaxSizeEnforcer(final GTRenderer renderer, PdfGraphics2D graphics, final int maxSize) {
        this.maxSize = maxSize;
        this.pdfBytes = graphics.getContent().getInternalBuffer();
        if (maxSize > 0) {
            renderer.addRenderListener(new RenderListener(){

                public void featureRenderer(SimpleFeature feature) {
                    if (PDFMaxSizeEnforcer.this.pdfBytes.size() > maxSize) {
                        renderer.stopRendering();
                    }
                }

                public void errorOccurred(Exception e) {
                }
            });
        }
    }

    public boolean exceedsMaxSize() {
        return this.maxSize > 0L && (long)this.pdfBytes.size() > this.maxSize;
    }

    public long memoryUsed() {
        return this.pdfBytes.size();
    }
}

