/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;

public final class GIFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(GIFMapResponse.class);
    static final String MIME_TYPE = "image/gif";
    static final String[] OUTPUT_FORMATS = new String[]{"image/gif"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, true, true);

    public GIFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    @Override
    public void formatImageOutputStream(RenderedImage originalImage, OutputStream outStream, WMSMapContent mapContent) throws ServiceException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing gif image ...");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Preparing to write a gif...");
        }
        try {
            originalImage = this.applyPalette(originalImage, mapContent, MIME_TYPE, false);
            ImageWorker iw = new ImageWorker(originalImage);
            iw.writeGIF((Object)outStream, "LZW", 0.75f);
            RasterCleaner.addImage(iw.getRenderedImage());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String getContentDisposition() {
        return null;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES;
    }

    @Override
    public String getExtension(RenderedImage image, WMSMapContent mapContent) {
        return "gif";
    }
}

