/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.TemplateUtils;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.ows.wmts.map.WMTSMapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.util.logging.Logging;

public abstract class AbstractOpenLayersMapOutputFormat
implements GetMapOutputFormat {
    protected static final Logger LOGGER = Logging.getLogger(AbstractOpenLayersMapOutputFormat.class);
    static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, true, true);
    private static final Set<String> ignoredParameters = new HashSet<String>();
    static final Configuration templateConfig;
    private WMS wms;

    public AbstractOpenLayersMapOutputFormat(WMS wms) {
        this.wms = wms;
    }

    @Override
    public RawMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        try {
            String templateName = this.getTemplateName(mapContent);
            Template template = templateConfig.getTemplate(templateName);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pureCoverage", Boolean.toString(this.hasOnlyCoverages(mapContent)));
            map.put("supportsFiltering", Boolean.toString(this.supportsFiltering(mapContent)));
            map.put("styles", this.styleNames(mapContent));
            GetMapRequest request = mapContent.getRequest();
            map.put("request", request);
            map.put("yx", Boolean.toString(this.isWms13FlippedCRS(request.getCrs())));
            map.put("maxResolution", Double.toString(this.getMaxResolution(mapContent.getRenderingArea())));
            ProjectionHandler handler = null;
            try {
                handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope(request.getCrs()), (CoordinateReferenceSystem)request.getCrs(), (boolean)this.wms.isContinuousMapWrappingEnabled());
            }
            catch (MismatchedDimensionException | FactoryException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
            map.put("global", Boolean.toString(handler != null && handler instanceof WrappingProjectionHandler));
            String baseUrl = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"/", null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            String queryString = null;
            if (baseUrl.indexOf("?") > 0) {
                int idx = baseUrl.indexOf("?");
                queryString = baseUrl.substring(idx);
                baseUrl = baseUrl.substring(0, idx);
            }
            String canonicBaseUrl = this.canonicUrl(baseUrl);
            map.put("baseUrl", canonicBaseUrl);
            map.put("relBaseUrl", this.makeProtocolRelativeURL(canonicBaseUrl));
            Object servicePath = "wms";
            if (LocalPublished.get() != null) {
                servicePath = LocalPublished.get().getName() + "/" + (String)servicePath;
            }
            if (LocalWorkspace.get() != null) {
                servicePath = LocalWorkspace.get().getName() + "/" + (String)servicePath;
            }
            if (queryString != null) {
                servicePath = (String)servicePath + queryString;
            }
            map.put("servicePath", servicePath);
            map.put("parameters", this.getLayerParameter(request.getRawKvp()));
            map.put("units", this.getUnits(mapContent));
            if (mapContent.layers().size() == 1) {
                map.put("layerName", ((Layer)mapContent.layers().get(0)).getTitle());
            } else {
                map.put("layerName", "Geoserver layers");
            }
            template.setOutputEncoding("UTF-8");
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            template.process(map, (Writer)new OutputStreamWriter((OutputStream)buff, StandardCharsets.UTF_8));
            RawMap result = new RawMap(mapContent, buff, this.getMimeType());
            return result;
        }
        catch (TemplateException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private String makeProtocolRelativeURL(String url) {
        if (!url.startsWith("http")) {
            return url;
        }
        int startFrom = url.startsWith("https://") ? 6 : 5;
        return url.substring(startFrom);
    }

    protected abstract String getUnits(WMSMapContent var1);

    protected abstract String getTemplateName(WMSMapContent var1);

    private boolean isWms13FlippedCRS(CoordinateReferenceSystem crs) {
        try {
            CoordinateReferenceSystem crs13;
            Object code = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false);
            if (code == null) {
                return false;
            }
            if (!((String)code).contains("EPSG:")) {
                code = "EPGS:" + (String)code;
            }
            return CRS.getAxisOrder((CoordinateReferenceSystem)(crs13 = CRS.decode((String)(code = WMS.toInternalSRS((String)code, WMS.version("1.3.0")))))) == CRS.AxisOrder.NORTH_EAST;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to determine CRS axis order, assuming is EN", e);
            return false;
        }
    }

    private boolean hasOnlyCoverages(WMSMapContent mapContent) {
        for (Layer layer : mapContent.layers()) {
            FeatureType schema = layer.getFeatureSource().getSchema();
            boolean grid = schema.getName().getLocalPart().equals("GridCoverage") && schema.getDescriptor("geom") != null && schema.getDescriptor("grid") != null && !(layer instanceof WMSLayer) && !(layer instanceof WMTSMapLayer);
            if (grid) continue;
            return false;
        }
        return true;
    }

    private boolean supportsFiltering(WMSMapContent mapContent) {
        return mapContent.layers().stream().anyMatch(layer -> {
            if (layer instanceof FeatureLayer) {
                return true;
            }
            if (!(layer instanceof GridReaderLayer)) {
                return false;
            }
            GeneralParameterValue[] readParams = ((GridReaderLayer)layer).getParams();
            if (readParams == null || readParams.length == 0) {
                return false;
            }
            for (GeneralParameterValue readParam : readParams) {
                if (!readParam.getDescriptor().getName().getCode().equalsIgnoreCase("FILTER")) continue;
                return true;
            }
            return false;
        });
    }

    private List<String> styleNames(WMSMapContent mapContent) {
        List<String> result;
        if (mapContent.layers().size() != 1 || mapContent.getRequest() == null) {
            result = this.getGroupStyleOrEmpty(mapContent);
        } else {
            MapLayerInfo info = mapContent.getRequest().getLayers().get(0);
            result = info.getOtherStyleNames();
        }
        return result;
    }

    private List<String> getGroupStyleOrEmpty(WMSMapContent mapContent) {
        List lgStyles;
        List<String> styles = Collections.emptyList();
        GetMapRequest request = mapContent.getRequest();
        LayerGroupInfo groupInfo = this.getLayerGroup(request);
        if (groupInfo != null && (lgStyles = groupInfo.getLayerGroupStyles()) != null && !lgStyles.isEmpty()) {
            styles = lgStyles.stream().map(s -> s.getName().getName()).collect(Collectors.toList());
        }
        return styles;
    }

    private LayerGroupInfo getLayerGroup(GetMapRequest getMapRequest) {
        LayerGroupInfo groupInfo = null;
        List layers = KvpUtils.readFlat((String)getMapRequest.getRawKvp().get("layers"));
        if (layers.size() == 1) {
            String name = (String)layers.get(0);
            Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
            groupInfo = catalog.getLayerGroupByName(name);
        }
        return groupInfo;
    }

    private List<Map<String, String>> getLayerParameter(Map<String, String> rawKvp) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(rawKvp.size());
        boolean exceptionsFound = false;
        for (Map.Entry<String, String> en : rawKvp.entrySet()) {
            String paramName = en.getKey();
            exceptionsFound |= paramName.equalsIgnoreCase("exceptions");
            if (ignoredParameters.contains(paramName.toUpperCase())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", paramName);
            map.put("value", en.getValue());
            result.add(map);
        }
        if (!exceptionsFound) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", "EXCEPTIONS");
            map.put("value", "application/vnd.ogc.se_inimage");
            result.add(map);
        }
        return result;
    }

    private String canonicUrl(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private double getMaxResolution(ReferencedEnvelope areaOfInterest) {
        double h;
        double w = areaOfInterest.getWidth();
        return (w > (h = areaOfInterest.getHeight()) ? w : h) / 256.0;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return CAPABILITIES;
    }

    static {
        ignoredParameters.add("REQUEST");
        ignoredParameters.add("TILED");
        ignoredParameters.add("BBOX");
        ignoredParameters.add("SERVICE");
        ignoredParameters.add("VERSION");
        ignoredParameters.add("FORMAT");
        ignoredParameters.add("WIDTH");
        ignoredParameters.add("HEIGHT");
        ignoredParameters.add("SRS");
        templateConfig = TemplateUtils.getSafeConfiguration(null, null, (Integer)2);
        templateConfig.setClassForTemplateLoading(AbstractOpenLayersMapOutputFormat.class, "");
        templateConfig.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
    }
}

