/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CascadedLegendRequest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.FeatureCountProcessor;
import org.geoserver.wms.legendgraphic.ImageList;
import org.geoserver.wms.legendgraphic.LegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendMerger;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.RasterLayerLegendHelper;
import org.geoserver.wms.legendgraphic.Tally;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.springframework.util.StringUtils;

public class BufferedImageLegendGraphicBuilder
extends LegendGraphicBuilder {
    Logger LOGGER = Logger.getLogger("org.geoserver.wms.legendgraphic");
    public static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter = new StyledShapePainter();
    private static final GeometryFactory geomFac = new GeometryFactory();
    private LiteShape2 samplePoint;
    private final double MINIMUM_SYMBOL_SIZE = 3.0;

    @Override
    public BufferedImage buildLegendGraphic(GetLegendGraphicRequest request) throws ServiceException {
        this.setup(request);
        Tally tally = new Tally(request.getWms());
        ImageList layersImages = new ImageList(tally);
        for (GetLegendGraphicRequest.LegendRequest legend : this.layers) {
            Rule[] applicableRules;
            FeatureType layer = legend.getFeatureType();
            Style gt2Style = legend.getStyle();
            if (gt2Style == null) {
                throw new NullPointerException("request.getStyle()");
            }
            gt2Style = this.applyRenderingSelection(gt2Style);
            String ruleName = legend.getRule();
            boolean strict = request.isStrict();
            gt2Style = this.resizeForDPI(request, gt2Style);
            boolean transparent = request.isTransparent();
            BufferedImage titleImage = null;
            if (this.layers.size() > 1 && !this.forceTitlesOff) {
                titleImage = this.getLayerTitle(legend, this.w, this.h, transparent, request);
            }
            this.checkForRenderingTransformations(gt2Style);
            boolean buildRasterLegend = !strict && layer == null && LegendUtils.checkRasterSymbolizer(gt2Style) || LegendUtils.checkGridLayer(layer) && !this.hasVectorTransformation || this.hasRasterTransformation;
            boolean useProvidedLegend = layer != null && legend.getLayerInfo() != null;
            BufferedImage legendImage = null;
            if (useProvidedLegend || legend instanceof CascadedLegendRequest) {
                boolean forceResize = !(legend instanceof CascadedLegendRequest);
                legendImage = this.getLayerLegend(legend, this.w, this.h, transparent, forceResize, request, titleImage);
            }
            if (useProvidedLegend && legendImage != null) {
                if (titleImage != null) {
                    layersImages.add(titleImage);
                }
                layersImages.add(legendImage);
                continue;
            }
            if (buildRasterLegend) {
                RasterLayerLegendHelper rasterLegendHelper = new RasterLayerLegendHelper(request, gt2Style, ruleName);
                BufferedImage image = rasterLegendHelper.getLegend(tally.getRemaining());
                if (image == null) continue;
                if (titleImage != null) {
                    layersImages.add(titleImage);
                }
                layersImages.add(image);
                continue;
            }
            if (legend instanceof CascadedLegendRequest) {
                if (titleImage != null) {
                    layersImages.add(titleImage);
                }
                if (legendImage == null) continue;
                layersImages.add(legendImage);
                continue;
            }
            Object sampleFeature = layer == null || this.hasVectorTransformation ? this.createSampleFeature() : this.createSampleFeature(layer);
            FeatureTypeStyle[] ftStyles = gt2Style.featureTypeStyles().toArray(new FeatureTypeStyle[0]);
            double scaleDenominator = request.getScale();
            if (ruleName != null) {
                Rule rule = LegendUtils.getRule(ftStyles, ruleName);
                if (rule == null) {
                    throw new ServiceException("Specified style does not contains a rule named " + ruleName);
                }
                applicableRules = new Rule[]{rule};
            } else {
                applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
            }
            if (this.countProcessor != null && !this.forceLabelsOff) {
                applicableRules = this.updateRuleTitles(this.countProcessor, legend, applicableRules);
            }
            NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
            int ruleCount = applicableRules.length;
            SLDStyleFactory styleFactory = new SLDStyleFactory();
            double minimumSymbolSize = 3.0;
            if (request.getLegendOptions().get("minSymbolSize") instanceof String) {
                String minSymbolSizeOpt = (String)request.getLegendOptions().get("minSymbolSize");
                try {
                    minimumSymbolSize = Double.parseDouble(minSymbolSizeOpt);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid minSymbolSize value: should be a number");
                }
            }
            int defaultSize = Math.min(this.w, this.h);
            double[] minMax = this.calcSymbolSize(defaultSize, minimumSymbolSize, layer, (Feature)sampleFeature, applicableRules);
            double actualMin = minMax[0];
            double actualMax = minMax[1];
            boolean rescalingRequired = actualMin < minimumSymbolSize || actualMax > (double)defaultSize;
            Function<Double, Double> rescaler = null;
            if (actualMax == actualMin || actualMin / actualMax * (double)defaultSize > minimumSymbolSize) {
                rescaler = size -> size / actualMax * (double)defaultSize;
            } else {
                double finalMinimumSymbolSize = minimumSymbolSize;
                rescaler = size -> (size - actualMin) / (actualMax - actualMin) * ((double)defaultSize - finalMinimumSymbolSize) + finalMinimumSymbolSize;
            }
            this.renderRules(request, layersImages, this.forceLabelsOn, this.forceLabelsOff, this.forceTitlesOff, layer, transparent, titleImage, (Feature)sampleFeature, scaleDenominator, applicableRules, (NumberRange<Double>)scaleRange, ruleCount, styleFactory, minimumSymbolSize, rescalingRequired, rescaler);
        }
        BufferedImage finalLegend = this.mergeGroups(layersImages, null, request, this.forceLabelsOn, this.forceLabelsOff, this.forceTitlesOff);
        if (finalLegend == null) {
            throw new IllegalArgumentException("no legend passed");
        }
        long maxMemory = layersImages.getTally().getMaxMemory();
        if (maxMemory != -1L && Tally.computeImageSize(finalLegend) > maxMemory) {
            throw new ServiceException("Max legend graphic memory usage exceeded.", "MaxMemoryExceeded");
        }
        return finalLegend;
    }

    private void renderRules(GetLegendGraphicRequest request, ImageList layersImages, boolean forceLabelsOn, boolean forceLabelsOff, boolean forceTitlesOff, FeatureType layer, boolean transparent, BufferedImage titleImage, Feature sampleFeature, double scaleDenominator, Rule[] applicableRules, NumberRange<Double> scaleRange, int ruleCount, SLDStyleFactory styleFactory, double minimumSymbolSize, boolean rescalingRequired, Function<Double, Double> rescaler) {
        BufferedImage image;
        MetaBufferEstimator estimator = new MetaBufferEstimator(sampleFeature);
        ImageList legendsStack = new ImageList(layersImages.getTally().getRemaining());
        for (int i = 0; i < ruleCount; ++i) {
            BufferedImage image2 = ImageUtils.createImage(this.w, this.h, null, transparent);
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            Graphics2D graphics = ImageUtils.prepareTransparency(transparent, LegendUtils.getBackgroundColor(request), image2, hintsMap);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Feature sample = this.getSampleFeatureForRule(layer, sampleFeature, applicableRules[i]);
            List symbolizers = applicableRules[i].symbolizers();
            GraphicLegend graphic = applicableRules[i].getLegend();
            if (graphic != null) {
                if (this.samplePoint == null) {
                    Coordinate coord = new Coordinate((double)(this.w / 2), (double)(this.h / 2));
                    try {
                        this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                    }
                    catch (Exception e) {
                        this.samplePoint = null;
                    }
                }
                shapePainter.paint(graphics, this.samplePoint, graphic, scaleDenominator, false);
            } else {
                for (Symbolizer symbolizer : symbolizers) {
                    Style2D style2d;
                    if (symbolizer instanceof RasterSymbolizer) continue;
                    LiteShape2 shape = this.getSampleShape(symbolizer, this.w, this.h, this.w, this.h);
                    if (rescalingRequired && (symbolizer instanceof PointSymbolizer || symbolizer instanceof LineSymbolizer)) {
                        double size = this.getSymbolizerSize(estimator, symbolizer, Math.min(this.w, this.h) - 4);
                        double newSize = rescaler.apply(size);
                        symbolizer = this.rescaleSymbolizer(symbolizer, size, newSize);
                    } else if (symbolizer instanceof PolygonSymbolizer) {
                        double symbolizerSize = this.getSymbolizerSize(estimator, symbolizer, 0.0);
                        int rescaledWidth = this.integerSize(minimumSymbolSize, (double)this.w - symbolizerSize);
                        int rescaledHeight = this.integerSize(minimumSymbolSize, (double)this.h - symbolizerSize);
                        shape = this.getSampleShape(symbolizer, rescaledWidth, rescaledHeight, this.w, this.h);
                        symbolizer = this.rescaleSymbolizer(symbolizer, this.w, rescaledWidth);
                    }
                    if ((style2d = styleFactory.createStyle((Object)sample, symbolizer, scaleRange)) == null) continue;
                    shapePainter.paint(graphics, shape, style2d, scaleDenominator);
                }
            }
            if (image2 != null && titleImage != null) {
                layersImages.add(titleImage);
                titleImage = null;
            }
            legendsStack.add(image2);
            graphics.dispose();
        }
        int labelMargin = 3;
        if (request.getLegendOptions().get("labelMargin") != null && StringUtils.hasText((String)request.getLegendOptions().get("labelMargin").toString())) {
            labelMargin = Integer.parseInt(request.getLegendOptions().get("labelMargin").toString());
        }
        LegendMerger.MergeOptions options = LegendMerger.MergeOptions.createFromRequest(legendsStack, 0, 0, 0, labelMargin, request, forceLabelsOn, forceLabelsOff, forceTitlesOff);
        if (ruleCount > 0 && (image = LegendMerger.mergeLegends(applicableRules, request, options)) != null) {
            layersImages.add(image);
        }
    }

    private int integerSize(double minimumSymbolSize, double size) {
        return (int)Math.ceil(Math.max(minimumSymbolSize, size));
    }

    @Override
    public Symbolizer rescaleSymbolizer(Symbolizer symbolizer, double size, double newSize) {
        final double scaleFactor = newSize / size;
        RescaleStyleVisitor rescaleVisitor = new RescaleStyleVisitor(scaleFactor){

            protected Expression rescale(Expression expr) {
                if (expr == null) {
                    return null;
                }
                if (expr instanceof Literal) {
                    Double value = (Double)expr.evaluate(null, Double.class);
                    return this.ff.literal(value * scaleFactor);
                }
                return this.ff.multiply(expr, (Expression)this.ff.literal(scaleFactor));
            }
        };
        symbolizer.accept((StyleVisitor)rescaleVisitor);
        symbolizer = (Symbolizer)rescaleVisitor.getCopy();
        return symbolizer;
    }

    private BufferedImage getLayerTitle(GetLegendGraphicRequest.LegendRequest legend, int w, int h, boolean transparent, GetLegendGraphicRequest request) {
        String title = legend.getTitle();
        BufferedImage image = ImageUtils.createImage(w, h, null, transparent);
        return LegendMerger.getRenderedLabel(image, title, request);
    }

    private BufferedImage getLayerLegend(GetLegendGraphicRequest.LegendRequest legend, int w, int h, boolean transparent, boolean forceDimensions, GetLegendGraphicRequest request, RenderedImage titleImage) {
        LegendInfo legendInfo = legend.getLegendInfo();
        if (legendInfo == null) {
            return null;
        }
        String onlineResource = legendInfo.getOnlineResource();
        if (onlineResource == null || onlineResource.isEmpty()) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(onlineResource);
        }
        catch (MalformedURLException invalid) {
            this.LOGGER.fine("Unable to obtain " + onlineResource);
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(url);
            if (image.getWidth() == w && image.getHeight() == h || !forceDimensions) {
                return image;
            }
            image = this.rescaleBufferedImage(image, titleImage != null ? titleImage : this.getLayerTitle(legend, w, h, transparent, request));
            BufferedImage rescale = ImageUtils.createImage(image.getWidth(), image.getHeight(), null, true);
            Graphics2D g = (Graphics2D)rescale.getGraphics();
            g.setColor(new Color(255, 255, 255, 0));
            g.fillRect(0, 0, w, h);
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            return rescale;
        }
        catch (IOException notFound) {
            this.LOGGER.log(Level.FINE, "Unable to legend graphic:" + url, notFound);
            return null;
        }
    }

    private BufferedImage mergeGroups(ImageList imageStack, Rule[] rules, GetLegendGraphicRequest req, boolean forceLabelsOn, boolean forceLabelsOff, boolean forceTitlesOff) {
        LegendMerger.MergeOptions options = LegendMerger.MergeOptions.createFromRequest(imageStack, 0, 0, 0, 0, req, forceLabelsOn, forceLabelsOff, forceTitlesOff);
        options.setLayout(LegendUtils.getGroupLayout(req));
        return LegendMerger.mergeGroups(rules, options);
    }

    protected Rule[] updateRuleTitles(FeatureCountProcessor processor, GetLegendGraphicRequest.LegendRequest legend, Rule[] applicableRules) {
        return processor.preProcessRules(legend, applicableRules);
    }

    protected BufferedImage rescaleBufferedImage(BufferedImage image, RenderedImage titleImage) {
        Image result;
        boolean stillTooBig;
        int titleHeight = titleImage != null ? titleImage.getHeight() : 0;
        int originalHeight = image.getHeight();
        int originalWidth = image.getWidth();
        double scaleFactor = this.getScale(originalHeight, this.h);
        double scaleFactorW = this.getScale(originalWidth, this.w);
        int scaleWidth = originalWidth >= this.w ? this.w : (int)Math.round((double)originalWidth * scaleFactorW);
        int scaleHeight = (int)Math.round((double)originalHeight * scaleFactor);
        int delta = (scaleHeight -= titleHeight) + titleHeight - this.h;
        boolean bl = stillTooBig = Math.signum(delta) >= 0.0f;
        if (stillTooBig) {
            scaleHeight -= (delta += titleHeight / 2);
        }
        if ((result = image.getScaledInstance(scaleWidth, scaleHeight, 1)) instanceof BufferedImage) {
            return (BufferedImage)result;
        }
        BufferedImage bufResult = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics g = bufResult.getGraphics();
        g.drawImage(result, 0, 0, null);
        g.dispose();
        return bufResult;
    }

    private double getScale(int original, int target) {
        return (double)target / (double)original;
    }
}

