/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.PlanarImage;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.clip.CroppedGridCoverage2DReader;
import org.geoserver.wms.featureinfo.AttributeTableEnricher;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcher;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcherExtractor;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geoserver.wms.featureinfo.RasterAttributeTableVisitor;
import org.geoserver.wms.featureinfo.VectorBasicLayerIdentifier;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.CoverageReadingTransformation;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.TransformedPosition;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.ows.ServiceException;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class RasterLayerIdentifier
implements LayerIdentifier<GridCoverage2DReader> {
    static final Logger LOGGER = Logging.getLogger(RasterLayerIdentifier.class);
    public static final String INCLUDE_RAT = "addAttributeTable";
    private WMS wms;

    public RasterLayerIdentifier(WMS wms) {
        this.wms = wms;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        int type = layer.getType();
        return type == MapLayerInfo.TYPE_RASTER;
    }

    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters requestParams, int maxFeatures) throws Exception {
        MapLayerInfo layer = requestParams.getLayer();
        Filter filter = requestParams.getFilter();
        SortBy[] sort = requestParams.getSort();
        CoverageInfo cinfo = layer.getCoverage();
        GridCoverage2DReader reader = this.handleClipParam(requestParams, (GridCoverage2DReader)cinfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints()));
        Position position = this.getQueryPosition(requestParams, cinfo, reader);
        if (!reader.getOriginalEnvelope().contains(position)) {
            return null;
        }
        GeneralParameterValue[] parameters = this.setupReadParameters(requestParams, layer, filter, sort, cinfo, reader, position);
        if (parameters == null) {
            return null;
        }
        ArrayList<FeatureCollection> result = new ArrayList<FeatureCollection>();
        boolean plainRenderingIdentified = false;
        for (FeatureTypeStyle fts : requestParams.getStyle().featureTypeStyles()) {
            Expression tx;
            Expression expression = tx = this.isTransformFeatureInfo(fts) ? fts.getTransformation() : null;
            if (tx == null && plainRenderingIdentified) continue;
            plainRenderingIdentified |= tx == null;
            Object info = this.read(requestParams, reader, parameters, fts);
            if (info instanceof GridCoverage2D) {
                GridCoverage2D coverage = (GridCoverage2D)info;
                result.addAll(this.toFeatures(cinfo, reader, coverage, position, requestParams));
                continue;
            }
            if (info instanceof FeatureCollection) {
                FeatureCollection fc = (FeatureCollection)info;
                result.add(this.filterCollection(fc, requestParams));
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Unable to load raster data for this request.");
        }
        return result;
    }

    private boolean isTransformFeatureInfo(FeatureTypeStyle fts) {
        String option = (String)fts.getOptions().get("transformFeatureInfo");
        return option != null ? Boolean.parseBoolean(option) : this.wms.isTransformFeatureInfo();
    }

    private FeatureCollection filterCollection(FeatureCollection fc, FeatureInfoRequestParameters params) {
        int requestBuffer = params.getBuffer() <= 0 ? VectorBasicLayerIdentifier.MIN_BUFFER_SIZE : params.getBuffer();
        ReferencedEnvelope bbox = LayerIdentifier.getEnvelopeFilter(params, requestBuffer);
        FilterFactory ff = params.getFilterFactory();
        BBOX filter = ff.bbox((Expression)ff.property(""), (BoundingBox)bbox);
        return new FilteringFeatureCollection(fc, (Filter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FeatureCollection> toFeatures(CoverageInfo cinfo, GridCoverage2DReader reader, GridCoverage2D coverage, Position position, FeatureInfoRequestParameters requestParams) {
        SimpleFeatureCollection pixel = null;
        try {
            double[] pixelValues = coverage.evaluate(position, (double[])null);
            if (requestParams.isExcludeNodataResults() && this.pixelsAreNodata(coverage, pixelValues)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Returning no result due to nodata pixel");
                }
                for (int i = 0; i < pixelValues.length; ++i) {
                    pixelValues[i] = Double.NaN;
                }
            }
            Style style = requestParams.getStyle();
            double scaleDenominator = requestParams.getScaleDenominator();
            ColorMapLabelMatcherExtractor labelVisitor = new ColorMapLabelMatcherExtractor(scaleDenominator);
            style.accept((StyleVisitor)labelVisitor);
            List<ColorMapLabelMatcher> colorMapLabelMatcherList = labelVisitor.getColorMapLabelMatcherList();
            RasterAttributeTableVisitor ratVisitor = new RasterAttributeTableVisitor(scaleDenominator, cinfo.getNativeCoverageName(), reader);
            style.accept((StyleVisitor)ratVisitor);
            AttributeTableEnricher ratEnricher = ratVisitor.getAttributeTableEnricher();
            pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getQualifiedName(), colorMapLabelMatcherList, ratEnricher);
        }
        catch (PointOutsideCoverageException ri) {
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            coverage.dispose(true);
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
        return Collections.singletonList(pixel);
    }

    private GeneralParameterValue[] setupReadParameters(FeatureInfoRequestParameters requestParams, MapLayerInfo layer, Filter filter, SortBy[] sort, CoverageInfo cinfo, GridCoverage2DReader reader, Position position) throws IOException, TransformException, ServiceException {
        GetMapRequest getMap = requestParams.getGetMapRequest();
        List<Object> times = requestParams.getTimes();
        List<Object> elevations = requestParams.getElevations();
        this.wms.validateRasterDimensions(times, elevations, layer, requestParams.getGetMapRequest());
        GeneralParameterValue[] parameters = this.wms.getWMSReadParameters(getMap, layer, filter, sort, times, elevations, reader, true);
        MathTransform worldToGrid = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
        Position rasterMid = worldToGrid.transform(position, null);
        Rectangle2D.Double rasterArea = new Rectangle2D.Double();
        rasterArea.setFrameFromCenter(rasterMid.getOrdinate(0), rasterMid.getOrdinate(1), rasterMid.getOrdinate(0) + 2.0, rasterMid.getOrdinate(1) + 2.0);
        Rectangle integerRasterArea = rasterArea.getBounds();
        GridEnvelope gridEnvelope = reader.getOriginalGridRange();
        Object originalArea = gridEnvelope instanceof GridEnvelope2D ? (GridEnvelope2D)gridEnvelope : new Rectangle();
        XRectangle2D.intersect((Rectangle2D)integerRasterArea, (Rectangle2D)originalArea, (Rectangle2D)integerRasterArea);
        if (integerRasterArea.isEmpty()) {
            return null;
        }
        String[] propertyNames = requestParams.getPropertyNames();
        for (GeneralParameterValue generalParameterValue : parameters) {
            if (!(generalParameterValue instanceof Parameter)) continue;
            Parameter parameter = (Parameter)generalParameterValue;
            ReferenceIdentifier name = parameter.getDescriptor().getName();
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                parameter.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(integerRasterArea), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem()));
                continue;
            }
            if (propertyNames == null || propertyNames.length <= 0 || !name.equals(AbstractGridFormat.BANDS.getName())) continue;
            int[] bands = new int[propertyNames.length];
            HashSet<String> requestedNames = new HashSet<String>(Arrays.asList(propertyNames));
            List dimensionNames = cinfo.getDimensions().stream().map(d -> d.getName()).collect(Collectors.toList());
            int j = 0;
            for (int i = 0; i < dimensionNames.size() && !requestedNames.isEmpty(); ++i) {
                String dimensionName = (String)dimensionNames.get(i);
                if (!requestedNames.remove(dimensionName)) continue;
                bands[j++] = i;
            }
            if (!requestedNames.isEmpty() && !this.hasVectorTransformations(requestParams)) {
                String availableNames = dimensionNames.stream().collect(Collectors.joining(", "));
                throw new ServiceException("Could not find the following requested properties " + requestedNames + ", available property names are " + availableNames, "InvalidParameterValue", "PropertyName");
            }
            parameter.setValue((Object)bands);
        }
        return parameters;
    }

    private boolean hasVectorTransformations(FeatureInfoRequestParameters params) {
        Style style = params.getStyle();
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(params.getScaleDenominator(), null, this.wms.isTransformFeatureInfo());
        style.accept((StyleVisitor)visitor);
        CoverageReadingTransformation readingTx = visitor.getCoverageReadingTransformation();
        return readingTx != null || this.getTransformation(visitor) != null;
    }

    private Position getQueryPosition(FeatureInfoRequestParameters params, CoverageInfo cinfo, GridCoverage2DReader reader) {
        CoordinateReferenceSystem requestedCRS = params.getRequestedCRS();
        CoordinateReferenceSystem targetCRS = cinfo.getProjectionPolicy() == ProjectionPolicy.NONE || cinfo.getProjectionPolicy() == ProjectionPolicy.REPROJECT_TO_DECLARED ? cinfo.getNativeCRS() : cinfo.getCRS();
        Coordinate middle = WMS.pixelToWorld(params.getX(), params.getY(), params.getRequestedBounds(), params.getWidth(), params.getHeight());
        double x = middle.x;
        double y = middle.y;
        Position targetCoverageMedianPosition = reader.getOriginalEnvelope().getMedian();
        if (requestedCRS != null && requestedCRS instanceof GeographicCRS) {
            TransformedPosition coverageMedianPosition = new TransformedPosition(targetCRS, requestedCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
            try {
                coverageMedianPosition.transform(targetCoverageMedianPosition);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException("Cannot find coverage median position in requested CRS", (Throwable)exception);
            }
            if (CRS.getAxisOrder((CoordinateReferenceSystem)requestedCRS) == CRS.AxisOrder.NORTH_EAST) {
                y += (double)(360L * Math.round((coverageMedianPosition.getOrdinate(1) - y) / 360.0));
            } else {
                x += (double)(360L * Math.round((coverageMedianPosition.getOrdinate(0) - x) / 360.0));
            }
        }
        Position2D position = new Position2D(requestedCRS, x, y);
        if (requestedCRS != null) {
            TransformedPosition arbitraryToInternal = new TransformedPosition(requestedCRS, targetCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
            try {
                arbitraryToInternal.transform((Position)position);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException("Unable to answer the geatfeatureinfo", (Throwable)exception);
            }
            position = arbitraryToInternal;
        }
        if (targetCRS != null && targetCRS instanceof GeographicCRS) {
            x = position.getOrdinate(0);
            y = position.getOrdinate(1);
            if (CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST) {
                y += (double)(360L * Math.round((targetCoverageMedianPosition.getOrdinate(1) - y) / 360.0));
            } else {
                x += (double)(360L * Math.round((targetCoverageMedianPosition.getOrdinate(0) - x) / 360.0));
            }
            position = new Position2D(targetCRS, x, y);
        }
        return position;
    }

    private Object read(FeatureInfoRequestParameters params, GridCoverage2DReader reader, GeneralParameterValue[] parameters, FeatureTypeStyle fts) throws IOException, SchemaException, TransformException, FactoryException {
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(params.getScaleDenominator(), null, this.wms.isTransformFeatureInfo());
        fts.accept((StyleVisitor)visitor);
        CoverageReadingTransformation readingTx = visitor.getCoverageReadingTransformation();
        if (readingTx != null) {
            CoverageReadingTransformation.ReaderAndParams ctx = new CoverageReadingTransformation.ReaderAndParams(reader, parameters);
            return readingTx.evaluate((Object)ctx);
        }
        Expression transformation = this.getTransformation(visitor);
        if (transformation != null && transformation instanceof RenderingTransformation) {
            ((RenderingTransformation)transformation).customizeReadParams((GridCoverageReader)reader, parameters);
        }
        GridCoverage2D coverage = reader.read(parameters);
        if (transformation != null) {
            RenderingTransformationHelper helper = new RenderingTransformationHelper(){

                protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object params, GridGeometry2D readGG) throws IOException {
                    throw new UnsupportedOperationException("This helper is meant to be used with a coverage already read");
                }
            };
            return helper.applyRenderingTransformation(transformation, (FeatureSource)DataUtilities.source((FeatureCollection)FeatureUtilities.wrapGridCoverage((GridCoverage2D)coverage)), Query.ALL, Query.ALL, null, coverage.getCoordinateReferenceSystem2D(), null);
        }
        if (!visitor.getRasterSymbolizers().isEmpty() || !this.isTransformFeatureInfo(fts)) {
            return coverage;
        }
        return null;
    }

    private Expression getTransformation(RasterSymbolizerVisitor visitor) {
        Expression result = visitor.getRasterRenderingTransformation();
        if (result == null && visitor.getOtherRenderingTransformations().size() == 1) {
            result = visitor.getOtherRenderingTransformations().get(0);
        }
        return result;
    }

    private boolean pixelsAreNodata(GridCoverage2D coverage, double[] values) {
        RenderedImage ri = coverage.getRenderedImage();
        ImageWorker worker = new ImageWorker(ri);
        Range nodata = worker.getNoData();
        int nodataValues = 0;
        if (nodata != null) {
            for (double value : values) {
                if (!nodata.contains(value)) continue;
                ++nodataValues;
            }
        }
        return nodataValues == values.length;
    }

    private SimpleFeatureCollection wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, Name coverageName, List<ColorMapLabelMatcher> colorMapLabelMatcherList, AttributeTableEnricher ratEnricher) {
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(coverageName);
        boolean isLabelActive = !colorMapLabelMatcherList.isEmpty();
        boolean isLabelReplacingValue = ColorMapLabelMatcher.isLabelReplacingValue(colorMapLabelMatcherList);
        if (!isLabelReplacingValue) {
            this.addBandNamesToFeatureType(sampleDimensions, builder);
        }
        if (isLabelActive) {
            this.addLabelAttributeNameToFeatureType(colorMapLabelMatcherList, builder, coverage);
        }
        if (ratEnricher != null) {
            ratEnricher.addAttributes(builder);
        }
        SimpleFeatureType gridType = builder.buildFeatureType();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < pixelValues.length; ++i) {
            double pixelVal = pixelValues[i];
            if (isLabelActive) {
                this.addValueToLabelListByPixel(labels, colorMapLabelMatcherList, pixelVal, i);
            }
            if (isLabelReplacingValue) continue;
            values.add(pixelVal);
        }
        if (isLabelActive) {
            values.addAll(labels);
        }
        if (ratEnricher != null) {
            ratEnricher.addRowValues(values, pixelValues);
        }
        return DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)gridType, values, (String)""));
    }

    private void addBandNamesToFeatureType(GridSampleDimension[] sampleDimensions, SimpleFeatureTypeBuilder builder) {
        HashSet<String> bandNames = new HashSet<String>();
        for (int i = 0; i < sampleDimensions.length; ++i) {
            String name = RasterLayerIdentifier.descriptionToNcName(sampleDimensions[i].getDescription().toString());
            if (bandNames.contains(name)) {
                name = name + "_Band" + i;
            }
            bandNames.add(name);
            builder.add(name, Double.class);
        }
    }

    private void addLabelAttributeNameToFeatureType(List<ColorMapLabelMatcher> colorMapLabelMatcherList, SimpleFeatureTypeBuilder builder, GridCoverage2D coverage) {
        int numLabel = ColorMapLabelMatcher.getLabelAttributeNameCount(colorMapLabelMatcherList);
        int indexLabel = 1;
        for (ColorMapLabelMatcher lifi : colorMapLabelMatcherList) {
            Object label = lifi.getAttributeName();
            Integer channelName = lifi.getChannel();
            if (((String)label).equals("Label")) {
                String labelIndexed = numLabel > 1 ? (String)label + indexLabel : label;
                ++indexLabel;
                GridSampleDimension sampleDimension = channelName != null ? coverage.getSampleDimension(channelName - 1) : coverage.getSampleDimensions()[0];
                String sampleDimDesc = sampleDimension.getDescription().toString();
                label = labelIndexed + "_" + RasterLayerIdentifier.descriptionToNcName(sampleDimDesc);
            }
            builder.add((String)label, String.class);
        }
    }

    private void addValueToLabelListByPixel(List<String> labels, List<ColorMapLabelMatcher> colorMapLabelMatcherList, double pixel, int currentPixelIdx) {
        for (ColorMapLabelMatcher lifi : colorMapLabelMatcherList) {
            Integer channelName = lifi.getChannel();
            if (channelName != null && currentPixelIdx != channelName - 1) continue;
            labels.add(lifi.getLabelForPixel(pixel));
        }
    }

    static String descriptionToNcName(String description) {
        if (description == null || description.isEmpty()) {
            return "Unknown";
        }
        char[] result = description.toCharArray();
        for (int i = 0; i < result.length; ++i) {
            if ((i != 0 || DataValue.XMLChar.isNCNameStart((int)result[i])) && (i <= 0 || DataValue.XMLChar.isNCName((int)result[i]))) continue;
            result[i] = 95;
        }
        return String.valueOf(result);
    }

    @Override
    public GridCoverage2DReader handleClipParam(FeatureInfoRequestParameters params, GridCoverage2DReader reader) {
        Geometry roiGeom = params.getGetMapRequest().getClip();
        if (roiGeom == null) {
            return reader;
        }
        return new CroppedGridCoverage2DReader(reader, roiGeom);
    }
}

