/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.springframework.util.Assert;

public class GetFeatureInfoResponse
extends Response {
    private final WMS wms;
    private GetFeatureInfoOutputFormat defaultOutputFormat;

    public GetFeatureInfoResponse(WMS wms, GetFeatureInfoOutputFormat defaultOutputFormat) {
        super(FeatureCollectionType.class);
        this.wms = wms;
        this.defaultOutputFormat = defaultOutputFormat;
    }

    public boolean canHandle(Operation operation) {
        return "GetFeatureInfo".equalsIgnoreCase(operation.getId());
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Assert.notNull((Object)value, (String)"value is null");
        Assert.notNull((Object)operation, (String)"operation is null");
        Assert.isTrue((boolean)(value instanceof FeatureCollectionType), (String)"unrecognized result type:");
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureInfoRequest.class);
        Assert.notNull((Object)request, (String)"request");
        GetFeatureInfoOutputFormat outputFormat = this.getRequestedOutputFormat(request);
        return outputFormat.getContentType();
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.notNull((Object)value, (String)"value is null");
        Assert.notNull((Object)operation, (String)"operation is null");
        Assert.isTrue((boolean)(value instanceof FeatureCollectionType), (String)"unrecognized result type:");
        Assert.isTrue((operation.getParameters() != null && operation.getParameters().length == 1 && operation.getParameters()[0] instanceof GetFeatureInfoRequest ? 1 : 0) != 0, (String)"Operation parameters should be a single GetFeatureInfoRequest");
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)operation.getParameters()[0];
        FeatureCollectionType results = (FeatureCollectionType)value;
        GetFeatureInfoOutputFormat outputFormat = this.getRequestedOutputFormat(request);
        outputFormat.write(results, request, output);
    }

    private GetFeatureInfoOutputFormat getRequestedOutputFormat(GetFeatureInfoRequest request) throws ServiceException {
        String requestFormat = request.getInfoFormat();
        GetFeatureInfoOutputFormat format = this.wms.getFeatureInfoOutputFormat(requestFormat);
        if (format == null) {
            format = this.defaultOutputFormat;
        }
        if (!this.wms.isAllowedGetFeatureInfoFormat(format)) {
            throw this.wms.unallowedGetFeatureInfoFormatException(requestFormat);
        }
        return format;
    }

    public String getCharset(Operation operation) {
        Assert.notNull((Object)operation, (String)"operation is null");
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureInfoRequest.class);
        GetFeatureInfoOutputFormat outputFormat = this.getRequestedOutputFormat(request);
        return outputFormat.getCharset();
    }
}

