/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import it.geosolutions.imageio.pam.PAMDataset;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

class AttributeTableEnricher {
    private final PAMDataset.PAMRasterBand pamRasterBand;

    public AttributeTableEnricher(PAMDataset.PAMRasterBand pamRasterBand) {
        this.pamRasterBand = pamRasterBand;
    }

    private Predicate<PAMDataset.PAMRasterBand.Row> getRowMatcher(PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat, double value) {
        Optional<Integer> minMax = AttributeTableEnricher.getFieldWithUsage(rat, PAMDataset.PAMRasterBand.FieldUsage.MinMax);
        if (minMax.isPresent()) {
            return row -> {
                double f = Double.parseDouble((String)row.getF().get((Integer)minMax.get()));
                double magnitude = Math.max(Math.abs(f), Math.abs(value));
                double relativeTolerance = Math.ulp(magnitude) * 10.0;
                return Math.abs(f - value) <= relativeTolerance;
            };
        }
        Optional<Integer> min = AttributeTableEnricher.getFieldWithUsage(rat, PAMDataset.PAMRasterBand.FieldUsage.Min);
        Optional<Integer> max = AttributeTableEnricher.getFieldWithUsage(rat, PAMDataset.PAMRasterBand.FieldUsage.Max);
        if (min.isPresent() && max.isPresent()) {
            return row -> {
                List fields = row.getF();
                double fMin = Double.parseDouble((String)fields.get((Integer)min.get()));
                double fMax = Double.parseDouble((String)fields.get((Integer)max.get()));
                return fMin <= value && value <= fMax;
            };
        }
        throw new IllegalArgumentException("No field with usage MinMax or Min and Max found, RAT cannot be used to match pixel values.");
    }

    private static Optional<Integer> getFieldWithUsage(PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat, PAMDataset.PAMRasterBand.FieldUsage usage) {
        return rat.getFieldDefn().stream().filter(f -> f.getUsage() == usage).map(f -> f.getIndex()).findFirst();
    }

    private void addAttributeTableFieldsToFeatureType(PAMDataset.PAMRasterBand pamRasterBand, SimpleFeatureTypeBuilder builder) {
        List fields = pamRasterBand.getGdalRasterAttributeTable().getFieldDefn();
        for (PAMDataset.PAMRasterBand.FieldDefn field : fields) {
            Class type = String.class;
            switch (field.getType()) {
                case Integer: {
                    type = Long.class;
                    break;
                }
                case Real: {
                    type = Double.class;
                }
            }
            builder.add(field.getName(), type);
        }
    }

    public void addAttributes(SimpleFeatureTypeBuilder builder) {
        Integer band = this.pamRasterBand.getBand();
        if (band == null) {
            throw new RuntimeException("Band not found in PAMRasterBand");
        }
        this.addAttributeTableFieldsToFeatureType(this.pamRasterBand, builder);
    }

    public void addRowValues(List<Object> values, double[] pixelValues) {
        int band = this.pamRasterBand.getBand() - 1;
        if (band >= pixelValues.length) {
            throw new RuntimeException("Band in PAMRasterBand out of range, band: " + this.pamRasterBand.getBand() + ", pixelValues.length: " + pixelValues.length);
        }
        double value = pixelValues[band];
        PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = this.pamRasterBand.getGdalRasterAttributeTable();
        Predicate<PAMDataset.PAMRasterBand.Row> rowMatcher = this.getRowMatcher(rat, value);
        for (PAMDataset.PAMRasterBand.Row row : rat.getRow()) {
            if (!rowMatcher.test(row)) continue;
            List fields = row.getF();
            List defs = rat.getFieldDefn();
            block5: for (int i = 0; i < fields.size(); ++i) {
                switch (((PAMDataset.PAMRasterBand.FieldDefn)defs.get(i)).getType()) {
                    case Integer: {
                        values.add(Long.parseLong((String)fields.get(i)));
                        continue block5;
                    }
                    case Real: {
                        values.add(Double.parseDouble((String)fields.get(i)));
                        continue block5;
                    }
                    default: {
                        values.add(fields.get(i));
                    }
                }
            }
            return;
        }
        for (int i = 0; i < rat.getFieldDefn().size(); ++i) {
            values.add(null);
        }
    }

    PAMDataset.PAMRasterBand getPamRasterBand() {
        return this.pamRasterBand;
    }
}

