/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.GenericObjectModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.template.TemplateUtils;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.renderer.style.FontCache;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class TextDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private static Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private static final Configuration templateConfig = TemplateUtils.getSafeConfiguration(null, null, (Integer)3);
    String fontFamily;
    boolean fontBold;
    boolean fontItalic;
    float fontSize;
    float haloRadius;
    Color haloColor;
    Expression message;
    Color fontColor;

    @Override
    public void loadOptions(Map<String, Expression> options) throws Exception {
        this.message = options.get("message");
        if (this.message == null) {
            this.message = MapDecorationLayout.FF.literal((Object)"You forgot to set the 'message' option");
        }
        this.fontFamily = MapDecorationLayout.getOption(options, "font-family");
        if (options.get("font-italic") != null) {
            this.fontItalic = MapDecorationLayout.getOption(options, "font-italic", Boolean.class);
        }
        if (options.get("font-bold") != null) {
            this.fontBold = MapDecorationLayout.getOption(options, "font-bold", Boolean.class);
        }
        if (options.get("font-size") != null) {
            try {
                this.fontSize = MapDecorationLayout.getOption(options, "font-size", Float.class).floatValue();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'font-size' must be a float", e);
            }
        }
        if (options.get("font-color") != null) {
            try {
                this.fontColor = MapDecorationLayout.parseColor(MapDecorationLayout.getOption(options, "font-color"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'font-color' must be a color in #RRGGBB[AA] format.", e);
            }
        }
        if (this.fontColor == null) {
            this.fontColor = Color.BLACK;
        }
        if (options.get("halo-radius") != null) {
            try {
                this.haloRadius = MapDecorationLayout.getOption(options, "halo-radius", Float.class).floatValue();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'halo-radius' must be a float.", e);
            }
        }
        if (options.get("halo-color") != null) {
            try {
                this.haloColor = MapDecorationLayout.parseColor(MapDecorationLayout.getOption(options, "halo-color"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'halo-color' must be a color in #RRGGBB[AA] format.", e);
            }
        }
        if (this.haloRadius > 0.0f && this.haloColor == null) {
            this.haloColor = Color.WHITE;
        }
    }

    Font getFont() {
        Font font = DEFAULT_FONT;
        if (this.fontFamily != null && (font = FontCache.getDefaultInstance().getFont(this.fontFamily)) == null) {
            LOGGER.log(Level.WARNING, "Font " + this.fontFamily + " not found, falling back on the default");
            font = DEFAULT_FONT;
        }
        if (this.fontSize > 0.0f) {
            font = font.deriveFont(this.fontSize);
        }
        if (this.fontItalic) {
            font = font.deriveFont(2);
        }
        if (this.fontBold) {
            font = font.deriveFont(1);
        }
        return font;
    }

    String evaluateMessage(WMSMapContent content) throws IOException, TemplateException {
        String expandedMessage = (String)this.message.evaluate(null, String.class);
        if (this.message instanceof Literal) {
            return this.evaluateAsTemplate(content, expandedMessage);
        }
        return expandedMessage;
    }

    private String evaluateAsTemplate(WMSMapContent content, String message) throws IOException, TemplateException {
        final Map<String, Object> env = content.getRequest().getEnv();
        Template t = new Template("name", (Reader)new StringReader(message), templateConfig);
        final BeansWrapper bw = (BeansWrapper)templateConfig.getObjectWrapper();
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, (Object)new TemplateHashModel(){

            public boolean isEmpty() throws TemplateModelException {
                return env.isEmpty();
            }

            public TemplateModel get(String key) throws TemplateModelException {
                Request request;
                String value = (String)env.get(key);
                if (value == null && (request = (Request)Dispatcher.REQUEST.get()) != null && request.getRawKvp() != null) {
                    Object obj = request.getRawKvp().get(key);
                    value = (String)Converters.convert(obj, String.class);
                    if (obj != null && value == null) {
                        DefaultConversionService.getSharedInstance().convert(obj, String.class);
                    }
                }
                if (value != null) {
                    return new GenericObjectModel((Object)value, bw);
                }
                return null;
            }
        });
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) throws Exception {
        Font font = this.getFont();
        String message = this.evaluateMessage(mapContent);
        GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), message.toCharArray());
        Shape outline = gv.getOutline();
        Rectangle2D bounds = outline.getBounds2D();
        double width = bounds.getWidth() + (double)(this.haloRadius * 2.0f);
        double height = bounds.getHeight() + (double)(this.haloRadius * 2.0f);
        return new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) throws Exception {
        Font font = this.getFont();
        String message = this.evaluateMessage(mapContent);
        Font oldFont = g2d.getFont();
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        try {
            GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), message.toCharArray());
            AffineTransform at = AffineTransform.getTranslateInstance((float)paintArea.x + this.haloRadius, (float)(paintArea.y + paintArea.height) - this.haloRadius);
            Shape outline = gv.getOutline();
            outline = at.createTransformedShape(outline);
            if (this.haloRadius > 0.0f) {
                g2d.setColor(this.haloColor);
                g2d.setStroke(new BasicStroke(2.0f * this.haloRadius, 1, 1));
                g2d.draw(outline);
            }
            g2d.setFont(font);
            g2d.setColor(this.fontColor);
            g2d.fill(outline);
        }
        finally {
            g2d.setColor(oldColor);
            g2d.setFont(oldFont);
            g2d.setStroke(oldStroke);
        }
    }
}

