/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.util.Map;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.PolygonElement;
import org.geotools.grid.hexagon.HexagonOrientation;
import org.geotools.grid.hexagon.Hexagons;
import org.geotools.grid.oblong.Oblongs;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Polygon;

@DescribeProcess(title="Grid", description="Generates a georeferenced regular grid of cells.  Output contains the attributes: cell - the cell polygon; id - a unique identifier; centerX and centerY - the ordinates of the cell center.")
public class GridProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Generated grid cells as features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="bounds", description="Bounds of the grid") ReferencedEnvelope bounds, @DescribeParameter(name="width", description="Width of a cell (in units of the grid CRS)") double width, @DescribeParameter(name="height", description="Height of a cell (in units of the grid CRS).  Only for rectangular grid, defaults to equal width.", min=0) Double height, @DescribeParameter(name="vertexSpacing", description="Distance between vertices along cell sides (in units of the grid CRS)", min=0) Double vertexSpacing, @DescribeParameter(name="mode", description="Type of grid to be generated.  Specifies shape of cells in grid.", defaultValue="Rectangular") GridMode mode) throws ProcessException {
        double h;
        GridFeatureBuilderImpl builder = new GridFeatureBuilderImpl(bounds.getCoordinateReferenceSystem());
        double d = h = height != null ? height : width;
        SimpleFeatureSource source = mode == null || mode == GridMode.Rectangular ? Oblongs.createGrid((ReferencedEnvelope)bounds, (double)width, (double)h, (GridFeatureBuilder)builder) : (mode == GridMode.HexagonFlat ? Hexagons.createGrid((ReferencedEnvelope)bounds, (double)width, (HexagonOrientation)HexagonOrientation.FLAT, (GridFeatureBuilder)builder) : Hexagons.createGrid((ReferencedEnvelope)bounds, (double)width, (HexagonOrientation)HexagonOrientation.ANGLED, (GridFeatureBuilder)builder));
        try {
            return source.getFeatures();
        }
        catch (IOException e) {
            throw new ProcessException("Unexpected exception while grabbing features", e);
        }
    }

    static final class GridFeatureBuilderImpl
    extends GridFeatureBuilder {
        private int id;

        protected static SimpleFeatureType createType(CoordinateReferenceSystem crs) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName("grid");
            tb.add("cell", Polygon.class, crs);
            tb.add("id", Integer.class);
            tb.add("centerX", Double.class);
            tb.add("centerY", Double.class);
            return tb.buildFeatureType();
        }

        public GridFeatureBuilderImpl(CoordinateReferenceSystem crs) {
            super(GridFeatureBuilderImpl.createType(crs));
        }

        public String getFeatureID(GridElement ge) {
            return String.valueOf("grid." + this.id++);
        }

        public void setAttributes(GridElement ge, Map<String, Object> attributes) {
            PolygonElement pe = (PolygonElement)ge;
            attributes.put("id", this.id);
            attributes.put("centerX", pe.getCenter().x);
            attributes.put("centerY", pe.getCenter().y);
        }
    }

    public static enum GridMode {
        Rectangular,
        HexagonFlat,
        HexagonAngled;

    }
}

