/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.rest.catalog.AvailableResources;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class AvailableResourcesConverter
extends BaseMessageConverter<AvailableResources> {
    public AvailableResourcesConverter() {
        super(new MediaType[]{MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON});
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    protected boolean supports(Class<?> clazz) {
        return AvailableResources.class.isAssignableFrom(clazz);
    }

    protected AvailableResources readInternal(Class<? extends AvailableResources> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new HttpMessageNotReadableException("AvailableResourceConverter does not support deserialization", inputMessage);
    }

    protected void writeInternal(AvailableResources availableResources, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (MediaType.APPLICATION_XML.isCompatibleWith(contentType)) {
            this.writeXML(availableResources, outputMessage);
        } else if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
            this.writeJSON(availableResources, outputMessage);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void writeJSON(AvailableResources t, HttpOutputMessage outputMessage) throws IOException {
        JSONArray names = new JSONArray();
        names.addAll((Collection)t);
        JSONObject string = new JSONObject();
        string.put((Object)"string", (Object)names);
        JSONObject root = new JSONObject();
        root.put((Object)"list", (Object)string);
        try (OutputStream os = outputMessage.getBody();
             OutputStreamWriter writer = new OutputStreamWriter(os);){
            root.write((Writer)writer);
        }
    }

    protected void writeXML(AvailableResources t, HttpOutputMessage outputMessage) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, "UTF-8");
            writer.writeStartDocument();
            writer.writeStartElement("list");
            for (String name : t) {
                writer.writeStartElement(t.getName());
                writer.writeCharacters(name);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IOException(e);
        }
        try (OutputStream os = outputMessage.getBody();){
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamSource source = new StreamSource(new ByteArrayInputStream(out.toByteArray()));
            transformer.transform(source, new StreamResult(os));
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new IOException(e);
        }
    }
}

