/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.lang.reflect.Type;
import org.geoserver.config.GeoServer;
import org.geoserver.config.LoggingInfo;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/logging"})
public class LoggingController
extends AbstractGeoServerController {
    @Autowired
    public LoggingController(@Qualifier(value="geoServer") GeoServer geoServer) {
        super(geoServer);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<LoggingInfo> settingsGet() {
        return this.wrapObject(this.geoServer.getLogging(), LoggingInfo.class);
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void settingsPut(@RequestBody LoggingInfo loggingInfo) {
        LoggingInfo original = this.geoServer.getLogging();
        OwsUtils.copy((Object)loggingInfo, (Object)original, LoggingInfo.class);
        this.geoServer.save(original);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return LoggingInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }
}

