/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.MultiGeometry;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.utils.KmlCentroidBuilder;
import org.geoserver.kml.utils.KmlCentroidOptions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PlacemarkGeometryDecoratorFactory
implements KmlDecoratorFactory {
    static final KmlCentroidBuilder CENTROIDS = new KmlCentroidBuilder();

    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (Placemark.class.isAssignableFrom(featureClass)) {
            boolean hasHeightTemplate = this.hasHeightTemplate(context);
            boolean isExtrudeEnabled = this.isExtrudeEnabled(context);
            KmlCentroidOptions centroidOpts = KmlCentroidOptions.create(context);
            return new PlacemarkGeometryDecorator(hasHeightTemplate, isExtrudeEnabled, centroidOpts);
        }
        return null;
    }

    private boolean hasHeightTemplate(KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return false;
        }
        try {
            SimpleFeatureType schema = (SimpleFeatureType)context.getCurrentFeatureCollection().getSchema();
            return !context.getTemplate().isTemplateEmpty(schema, "height.ftl", FeatureTemplate.class, "0\n");
        }
        catch (IOException e) {
            throw new ServiceException("Failed to apply height template during kml generation", (Throwable)e);
        }
    }

    private boolean isExtrudeEnabled(KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return false;
        }
        Object foExtrude = context.getRequest().getFormatOptions().get("extrude");
        if (foExtrude == null) {
            return true;
        }
        Boolean extrude = (Boolean)Converters.convert(foExtrude, Boolean.class);
        return extrude == Boolean.TRUE;
    }

    static class PlacemarkGeometryDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        static final Logger LOGGER = Logging.getLogger(PlacemarkGeometryDecorator.class);
        private boolean hasHeightTemplate;
        private boolean extrudeEnabled;
        private KmlCentroidOptions centroidOpts;

        public PlacemarkGeometryDecorator(boolean hasHeightTemplate, boolean extrudeEnabled, KmlCentroidOptions centroidOpts) {
            this.hasHeightTemplate = hasHeightTemplate;
            this.extrudeEnabled = extrudeEnabled;
            this.centroidOpts = centroidOpts;
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            org.locationtech.jts.geom.Geometry geometry;
            Placemark pm = (Placemark)feature;
            SimpleFeature sf = context.getCurrentFeature();
            double height = Double.NaN;
            if (this.hasHeightTemplate) {
                try {
                    String output = context.getTemplate().template(sf, "height.ftl", FeatureTemplate.class);
                    height = Double.valueOf(output);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Couldn't render height template for " + sf.getID(), ioe);
                }
            }
            if ((geometry = this.getFeatureGeometry(sf, height)) != null) {
                pm.setGeometry(this.encodeGeometry(geometry, context, height));
            }
            return feature;
        }

        private org.locationtech.jts.geom.Geometry getFeatureGeometry(SimpleFeature sf, double height) {
            org.locationtech.jts.geom.Geometry geom = (org.locationtech.jts.geom.Geometry)sf.getDefaultGeometry();
            if (!Double.isNaN(height) && height != 0.0) {
                geom.apply(c -> c.setCoordinate(new Coordinate(c.x, c.y, height)));
                geom.geometryChanged();
            }
            return geom;
        }

        private Geometry encodeGeometry(org.locationtech.jts.geom.Geometry geometry, KmlEncodingContext context, double height) {
            boolean isSinglePoint;
            Geometry kmlGeometry = this.toKmlGeometry(geometry);
            boolean bl = isSinglePoint = geometry instanceof Point || geometry instanceof MultiPoint && geometry.getNumPoints() == 1;
            if (!isSinglePoint && context.isDescriptionEnabled()) {
                MultiGeometry mg = new MultiGeometry();
                Coordinate c = CENTROIDS.geometryCentroid(geometry, context.getRequest().getBbox(), this.centroidOpts);
                if (!Double.isNaN(height)) {
                    c.setOrdinate(2, height);
                }
                de.micromata.opengis.kml.v_2_2_0.Point kmlPoint = this.toKmlPoint(c);
                mg.addToGeometry((Geometry)kmlPoint);
                mg.addToGeometry(kmlGeometry);
                kmlGeometry = mg;
            }
            if (this.hasHeightTemplate) {
                this.applyExtrusion(kmlGeometry);
            }
            return kmlGeometry;
        }

        private de.micromata.opengis.kml.v_2_2_0.Point toKmlPoint(Coordinate c) {
            de.micromata.opengis.kml.v_2_2_0.Point result = new de.micromata.opengis.kml.v_2_2_0.Point();
            if (Double.isNaN(c.getZ())) {
                result.addToCoordinates(c.x, c.y);
            } else {
                result.addToCoordinates(c.x, c.y, c.getZ());
            }
            return result;
        }

        private Geometry toKmlGeometry(org.locationtech.jts.geom.Geometry geometry) {
            if (geometry == null) {
                return null;
            }
            if (geometry instanceof GeometryCollection) {
                MultiGeometry mg = new MultiGeometry();
                GeometryCollection gc = (GeometryCollection)geometry;
                if (gc.getNumGeometries() == 1) {
                    return this.toKmlGeometry(gc.getGeometryN(0));
                }
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    org.locationtech.jts.geom.Geometry child = gc.getGeometryN(i);
                    mg.addToGeometry(this.toKmlGeometry(child));
                }
                return mg;
            }
            if (geometry instanceof Point) {
                return this.toKmlPoint(geometry.getCoordinate());
            }
            if (geometry instanceof LinearRing) {
                return this.convertLinearRing((LinearRing)geometry);
            }
            if (geometry instanceof LineString) {
                de.micromata.opengis.kml.v_2_2_0.LineString kmlLine = new de.micromata.opengis.kml.v_2_2_0.LineString();
                List<de.micromata.opengis.kml.v_2_2_0.Coordinate> kmlCoordinates = this.dumpCoordinateSequence(((LineString)geometry).getCoordinateSequence());
                kmlLine.setCoordinates(kmlCoordinates);
                return kmlLine;
            }
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                de.micromata.opengis.kml.v_2_2_0.Polygon kmlPolygon = new de.micromata.opengis.kml.v_2_2_0.Polygon();
                de.micromata.opengis.kml.v_2_2_0.LinearRing kmlOuterRing = this.convertLinearRing(polygon.getExteriorRing());
                kmlPolygon.createAndSetOuterBoundaryIs().setLinearRing(kmlOuterRing);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interior = polygon.getInteriorRingN(i);
                    de.micromata.opengis.kml.v_2_2_0.LinearRing kmlInterior = this.convertLinearRing(interior);
                    kmlPolygon.createAndAddInnerBoundaryIs().setLinearRing(kmlInterior);
                }
                return kmlPolygon;
            }
            throw new IllegalArgumentException("Unrecognized geometry type: " + geometry);
        }

        private de.micromata.opengis.kml.v_2_2_0.LinearRing convertLinearRing(LinearRing geometry) {
            de.micromata.opengis.kml.v_2_2_0.LinearRing kmlLine = new de.micromata.opengis.kml.v_2_2_0.LinearRing();
            List<de.micromata.opengis.kml.v_2_2_0.Coordinate> kmlCoordinates = this.dumpCoordinateSequence(geometry.getCoordinateSequence());
            kmlLine.setCoordinates(kmlCoordinates);
            if (!this.hasHeightTemplate) {
                kmlLine.setTessellate(Boolean.valueOf(true));
            }
            return kmlLine;
        }

        private List<de.micromata.opengis.kml.v_2_2_0.Coordinate> dumpCoordinateSequence(CoordinateSequence cs) {
            ArrayList<de.micromata.opengis.kml.v_2_2_0.Coordinate> result = new ArrayList<de.micromata.opengis.kml.v_2_2_0.Coordinate>(cs.size());
            for (int i = 0; i < cs.size(); ++i) {
                double x = cs.getOrdinate(i, 0);
                double y = cs.getOrdinate(i, 1);
                double z = Double.NaN;
                if (cs.getDimension() >= 3 || this.hasHeightTemplate) {
                    z = cs.getOrdinate(i, 2);
                }
                de.micromata.opengis.kml.v_2_2_0.Coordinate c = Double.isNaN(z) ? new de.micromata.opengis.kml.v_2_2_0.Coordinate(x, y) : new de.micromata.opengis.kml.v_2_2_0.Coordinate(x, y, z);
                result.add(c);
            }
            return result;
        }

        public void applyExtrusion(Geometry kmlGeometry) {
            if (kmlGeometry instanceof de.micromata.opengis.kml.v_2_2_0.Polygon) {
                de.micromata.opengis.kml.v_2_2_0.Polygon polygon = (de.micromata.opengis.kml.v_2_2_0.Polygon)kmlGeometry;
                polygon.setExtrude(Boolean.valueOf(this.extrudeEnabled));
                polygon.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            } else if (kmlGeometry instanceof de.micromata.opengis.kml.v_2_2_0.LinearRing) {
                de.micromata.opengis.kml.v_2_2_0.LinearRing ring = (de.micromata.opengis.kml.v_2_2_0.LinearRing)kmlGeometry;
                ring.setExtrude(Boolean.valueOf(this.extrudeEnabled));
                ring.setTessellate(Boolean.valueOf(true));
                ring.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            } else if (kmlGeometry instanceof de.micromata.opengis.kml.v_2_2_0.LineString) {
                de.micromata.opengis.kml.v_2_2_0.LineString ls = (de.micromata.opengis.kml.v_2_2_0.LineString)kmlGeometry;
                ls.setExtrude(Boolean.valueOf(this.extrudeEnabled));
                ls.setTessellate(Boolean.valueOf(true));
                ls.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            } else if (kmlGeometry instanceof de.micromata.opengis.kml.v_2_2_0.Point) {
                de.micromata.opengis.kml.v_2_2_0.Point point = (de.micromata.opengis.kml.v_2_2_0.Point)kmlGeometry;
                point.setExtrude(Boolean.valueOf(this.extrudeEnabled));
                point.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            } else if (kmlGeometry instanceof MultiGeometry) {
                MultiGeometry mg = (MultiGeometry)kmlGeometry;
                for (Geometry g : mg.getGeometry()) {
                    this.applyExtrusion(g);
                }
            }
        }
    }
}

