/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.platform.ServiceException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class KMLEncoder {
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kml.class});

    public void encode(Kml kml, OutputStream output, KmlEncodingContext context) {
        try {
            if (context != null && context.getWms() == null) {
                this.createMarshaller().marshal((Object)kml, output);
            } else {
                this.createMarshaller().marshal((Object)kml, (ContentHandler)new KMLDocumentHandler(output));
            }
        }
        catch (JAXBException | TransformerException e) {
            throw new ServiceException(e);
        }
        finally {
            if (context != null) {
                context.closeIterators();
            }
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        return m;
    }

    private static final class KMLDocumentHandler
    implements ContentHandler {
        private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
        private static final List<String> IGNORED_ELEMENTS = List.of("refreshInterval", "viewRefreshTime", "viewBoundScale");
        private final TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
        private boolean inIconStyle = false;
        private boolean inIcon = false;
        private boolean inIgnoredElement = false;

        private KMLDocumentHandler(OutputStream output) throws TransformerException {
            this.transformerHandler.getTransformer().setOutputProperty("indent", "yes");
            this.transformerHandler.setResult(new StreamResult(output));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.transformerHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.transformerHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.transformerHandler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.transformerHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.transformerHandler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("IconStyle".equals(localName)) {
                this.inIconStyle = true;
            } else if (this.inIconStyle && "Icon".equals(localName)) {
                this.inIcon = true;
            } else if (this.inIcon && IGNORED_ELEMENTS.contains(localName)) {
                this.inIgnoredElement = true;
                return;
            }
            this.transformerHandler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("IconStyle".equals(localName)) {
                this.inIconStyle = false;
            } else if (this.inIconStyle && "Icon".equals(localName)) {
                this.inIcon = false;
            } else if (this.inIcon && IGNORED_ELEMENTS.contains(localName)) {
                this.inIgnoredElement = false;
                return;
            }
            this.transformerHandler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.inIgnoredElement) {
                this.transformerHandler.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.transformerHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.transformerHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.transformerHandler.skippedEntity(name);
        }
    }
}

