/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import it.geosolutions.imageio.plugins.tiff.TIFFCompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFLZWCompressor;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.GeoTiffWriterHelper;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wcs.WcsException;

public class GeoTIFFCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Logger LOGGER = Logging.getLogger((String)GeoTIFFCoverageResponseDelegate.class.toString());
    private static final float DEFAULT_JPEG_COMPRESSION_QUALITY = 0.75f;
    public static final String GEOTIFF_CONTENT_TYPE = "image/tiff";
    public static final String TILEWIDTH = "tilewidth";
    public static final String TILEHEIGHT = "tileheight";
    public static final String TILING = "tiling";
    public static final String COMPRESSION = "compression";

    public GeoTIFFCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, List.of("tif", "tiff", "geotiff", "TIFF", "GEOTIFF", "GeoTIFF", "image/geotiff", "image/tiff;application=geotiff"), Map.ofEntries(Map.entry("tif", "tif"), Map.entry("tiff", "tif"), Map.entry("geotiff", "tif"), Map.entry("TIFF", "tif"), Map.entry("GEOTIFF", "tif"), Map.entry("GeoTIFF", "tif"), Map.entry("image/geotiff", "tif"), Map.entry(GEOTIFF_CONTENT_TYPE, "tif"), Map.entry("image/tiff;application=geotiff", "tif")), Map.ofEntries(Map.entry("tiff", GEOTIFF_CONTENT_TYPE), Map.entry("tif", GEOTIFF_CONTENT_TYPE), Map.entry("geotiff", GEOTIFF_CONTENT_TYPE), Map.entry("TIFF", GEOTIFF_CONTENT_TYPE), Map.entry("GEOTIFF", GEOTIFF_CONTENT_TYPE), Map.entry("GeoTIFF", GEOTIFF_CONTENT_TYPE), Map.entry("image/geotiff", GEOTIFF_CONTENT_TYPE), Map.entry("image/tiff;application=geotiff", "image/tiff;application=geotiff")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> encodingParameters, OutputStream output) throws IOException {
        Utilities.ensureNonNull((String)"sourceCoverage", (Object)sourceCoverage);
        Utilities.ensureNonNull((String)"encodingParameters", encodingParameters);
        GeoTiffWriterHelper writerHelper = new GeoTiffWriterHelper(sourceCoverage);
        this.handleCompression(encodingParameters, writerHelper);
        this.handleTiling(encodingParameters, sourceCoverage, writerHelper);
        this.handleInterleaving(encodingParameters, sourceCoverage, writerHelper);
        if (((WCSInfo)this.geoserver.getService(WCSInfo.class)).isLatLon()) {
            ParameterValueGroup gp = writerHelper.getGeotoolsWriteParams();
            gp.parameter(GeoTiffFormat.RETAIN_AXES_ORDER.getName().toString()).setValue(true);
        }
        try {
            writerHelper.write(output);
        }
        finally {
            sourceCoverage.dispose(false);
        }
    }

    private void handleInterleaving(Map<String, String> encondingParameters, GridCoverage2D sourceCoverage, GeoTiffWriterHelper writerHelper) throws WcsException {
        if (encondingParameters.containsKey("interleave")) {
            String interleavingS = encondingParameters.get("interleave");
            if (interleavingS.equals("band") || interleavingS.equals("Band")) {
                throw new OWS20Exception("Banded Interleaving not supported", this.ows20Code(WcsException.WcsExceptionCode.InterleavingNotSupported), interleavingS);
            }
            if (!interleavingS.equals("pixel") && !interleavingS.equals("Pixel")) {
                throw new OWS20Exception("Invalid Interleaving type provided", this.ows20Code(WcsException.WcsExceptionCode.InterleavingInvalid), interleavingS);
            }
        }
    }

    private OWS20Exception.OWSExceptionCode ows20Code(WcsException.WcsExceptionCode code) {
        return new OWS20Exception.OWSExceptionCode(code.toString(), Integer.valueOf(404));
    }

    private void handleTiling(Map<String, String> encodingParameters, GridCoverage2D sourceCoverage, GeoTiffWriterHelper helper) throws WcsException {
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        SampleModel sampleModel = sourceImage.getSampleModel();
        int sourceTileW = sampleModel.getWidth();
        int sourceTileH = sampleModel.getHeight();
        Dimension tileDimensions = new Dimension(sourceTileW, sourceTileH);
        LOGGER.fine("Source tiling:" + tileDimensions.width + "x" + tileDimensions.height);
        GridEnvelope gr = sourceCoverage.getGridGeometry().getGridRange();
        if (gr.getSpan(0) < tileDimensions.width) {
            tileDimensions.width = gr.getSpan(0);
        }
        if (gr.getSpan(1) < tileDimensions.height) {
            tileDimensions.height = gr.getSpan(1);
        }
        LOGGER.fine("Source tiling reviewed to save space:" + tileDimensions.width + "x" + tileDimensions.height);
        if (encodingParameters.containsKey(TILING)) {
            String tilingS = encodingParameters.get(TILING);
            if (tilingS != null && Boolean.valueOf(tilingS).booleanValue()) {
                String tileH_;
                String tileW_;
                if (encodingParameters.containsKey(TILEWIDTH) && (tileW_ = encodingParameters.get(TILEWIDTH)) != null) {
                    try {
                        int tileW = Integer.valueOf(tileW_);
                        if (tileW <= 0 || tileW % 16 != 0) {
                            throw new OWS20Exception("Provided tile width is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), Integer.toString(tileW));
                        }
                        tileDimensions.width = tileW;
                    }
                    catch (Exception e) {
                        throw new OWS20Exception("Provided tile width is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), tileW_);
                    }
                }
                if (encodingParameters.containsKey(TILEHEIGHT) && (tileH_ = encodingParameters.get(TILEHEIGHT)) != null) {
                    try {
                        int tileH = Integer.valueOf(tileH_);
                        if (tileH <= 0 || tileH % 16 != 0) {
                            throw new OWS20Exception("Provided tile height is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), Integer.toString(tileH));
                        }
                        tileDimensions.height = tileH;
                    }
                    catch (Exception e) {
                        throw new OWS20Exception("Provided tile height is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), tileH_);
                    }
                }
            }
            GeoTiffWriteParams wp = helper.getImageIoWriteParams();
            helper.disableSourceCopyOptimization();
            wp.setTilingMode(2);
            wp.setTiling(tileDimensions.width, tileDimensions.height);
        }
    }

    private void handleCompression(Map<String, String> encodingParameters, GeoTiffWriterHelper helper) throws WcsException {
        if (encodingParameters.containsKey(COMPRESSION)) {
            GeoTiffWriteParams wp = helper.getImageIoWriteParams();
            helper.disableSourceCopyOptimization();
            String compressionS = encodingParameters.get(COMPRESSION);
            if (compressionS != null && !compressionS.equalsIgnoreCase("none")) {
                if (compressionS.equals("LZW")) {
                    wp.setCompressionMode(2);
                    wp.setCompressionType("LZW");
                    String predictorS = encodingParameters.get("predictor");
                    if (predictorS != null) {
                        if (predictorS.equals("Horizontal")) {
                            wp.setTIFFCompressor((TIFFCompressor)new TIFFLZWCompressor(2));
                        } else {
                            if (predictorS.equals("Floatingpoint")) {
                                throw new OWS20Exception("Floating Point predictor is not supported", this.ows20Code(WcsException.WcsExceptionCode.PredictorNotSupported), predictorS);
                            }
                            if (!predictorS.equals("None")) {
                                throw new OWS20Exception("Invalid Predictor provided", this.ows20Code(WcsException.WcsExceptionCode.PredictorInvalid), predictorS);
                            }
                        }
                    }
                } else if (compressionS.equals("JPEG")) {
                    String quality_;
                    wp.setCompressionMode(2);
                    wp.setCompressionType("JPEG");
                    wp.setCompressionQuality(0.75f);
                    if (encodingParameters.containsKey("jpeg_quality") && (quality_ = encodingParameters.get("jpeg_quality")) != null) {
                        try {
                            int quality = Integer.valueOf(quality_);
                            if (quality <= 0 || quality > 100) {
                                throw new OWS20Exception("Provided quality value for the jpeg compression in invalid", this.ows20Code(WcsException.WcsExceptionCode.JpegQualityInvalid), quality_);
                            }
                            wp.setCompressionQuality((float)quality / 100.0f);
                        }
                        catch (Exception e) {
                            throw new OWS20Exception("Provided quality value for the jpeg compression in invalid", this.ows20Code(WcsException.WcsExceptionCode.JpegQualityInvalid), quality_);
                        }
                    }
                } else if (compressionS.equals("PackBits")) {
                    wp.setCompressionMode(2);
                    wp.setCompressionType("PackBits");
                } else if (compressionS.equals("DEFLATE") || compressionS.equals("Deflate")) {
                    WCSInfo info;
                    wp.setCompressionMode(2);
                    wp.setCompressionType("Deflate");
                    if (this.geoserver != null && (info = (WCSInfo)this.geoserver.getService(WCSInfo.class)) != null) {
                        int deflateLevel = info.getDefaultDeflateCompressionLevel();
                        wp.setCompressionQuality((float)(deflateLevel - 1) * 0.125f);
                    }
                } else if (compressionS.equals("Huffman")) {
                    wp.setCompressionMode(2);
                    wp.setCompressionType("CCITT RLE");
                } else {
                    throw new OWS20Exception("Provided compression does not seem supported", this.ows20Code(WcsException.WcsExceptionCode.CompressionInvalid), compressionS);
                }
            }
        }
    }

    @Override
    public String getConformanceClass(String format) {
        return "http://www.opengis.net/spec/GMLCOV_geotiff-coverages/1.0/conf/geotiff-coverage";
    }
}

