/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;

public class DebugCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public DebugCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, List.of("DEBUG", "text/debug"), Map.ofEntries(Map.entry("DEBUG", "txt"), Map.entry("text/debug", "txt"), Map.entry("text/plain", "txt")), Map.ofEntries(Map.entry("DEBUG", "text/plain"), Map.entry("text/debug", "text/plain")));
    }

    @Override
    public void encode(GridCoverage2D coverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        PrintStream ps = new PrintStream(output);
        ps.println("Grid bounds: " + coverage.getEnvelope());
        ps.println("Grid CRS: " + coverage.getCoordinateReferenceSystem());
        ps.println("Grid range: " + coverage.getGridGeometry().getGridRange());
        ps.println("Grid to world: " + coverage.getGridGeometry().getGridToCRS());
        ps.println("Contents:");
        RenderedImage ri = coverage.getRenderedImage();
        Raster raster = ri.getData();
        for (int band = 0; band < raster.getNumBands(); ++band) {
            ps.println("Band " + band + ":");
            for (int j = raster.getMinY(); j < raster.getMinY() + raster.getHeight(); ++j) {
                for (int i = raster.getMinX(); i < raster.getMinX() + raster.getWidth(); ++i) {
                    if (raster.getTransferType() == 5) {
                        ps.print(raster.getSampleDouble(i, j, band));
                    } else if (raster.getTransferType() == 4) {
                        ps.print(raster.getSampleFloat(i, j, band));
                    } else {
                        ps.print(raster.getSample(i, j, band));
                    }
                    if (i >= raster.getMinX() + raster.getWidth() - 1) continue;
                    ps.print(" ");
                }
                ps.println();
            }
        }
        ps.flush();
        coverage.dispose(false);
    }
}

