/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.Optional;
import java.util.logging.Logger;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.kvp.ClipGeometryParser;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.EmptyIntersectionException;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.vfny.geoserver.util.WCSUtils;

public class WCSCoverageClipCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(WCSCoverageClipCallback.class);
    private Class<?> granuleStackClass = null;

    public WCSCoverageClipCallback() {
        try {
            this.granuleStackClass = Class.forName("org.geoserver.wcs2_0.response.GranuleStack");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        if (!("WCS".equalsIgnoreCase(request.getService()) && "GetCoverage".equalsIgnoreCase(request.getRequest()) && Optional.ofNullable(request.getRawKvp()).map(m -> m.containsKey("CLIP")).orElse(false).booleanValue())) {
            return result;
        }
        if (!this.acceptResult(result)) {
            return result;
        }
        try {
            LOGGER.fine("Clipping coverage data");
            GridCoverage coverage = (GridCoverage)result;
            Geometry clip = ClipGeometryParser.readGeometry((String)((String)request.getRawKvp().get("CLIP")), (CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
            return this.performClip(coverage, clip);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (EmptyIntersectionException e) {
            throw new ServiceException("Clip polygon does not overlap coverage data", "InvalidParameterValue", "clip");
        }
        catch (Exception e) {
            throw new ServiceException("Failed to clip coverage", (Throwable)e);
        }
    }

    protected boolean acceptResult(Object result) {
        if (this.granuleStackClass != null && this.granuleStackClass.isInstance(result)) {
            return false;
        }
        return result instanceof GridCoverage2D;
    }

    protected GridCoverage performClip(GridCoverage coverage, Geometry clip) {
        return WCSUtils.crop((GridCoverage2D)coverage, clip);
    }
}

