/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.wk;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.hatbox.wk.ParseException;
import net.sourceforge.hatbox.wk.ParserConstants;
import net.sourceforge.hatbox.wk.WKBGeometryType;

public class WKTParseState
implements ParserConstants {
    private WKBGeometryType type;
    private int state = 0;
    private Coord coord;
    private List<Coord> linestring;
    private List<List<Coord>> linestrings;
    private WKTParseState parent;
    private List<WKTParseState> children;
    private StringBuilder buf;
    private byte[] intBuf = new byte[4];
    private byte[] longBuf = new byte[8];

    public WKTParseState pointToken(int token) throws ParseException {
        if (token == 40) {
            if (this.state == 0) {
                this.coord = new Coord();
                this.state = 4;
                return this;
            }
            throw new ParseException("Misplaced open: " + this.buf + " <===");
        }
        if (token == 41) {
            if (this.state == 20) {
                this.state = 22;
                if (this.parent == null) {
                    return this;
                }
                return this.parent;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        throw new ParseException("Misplaced token: " + this.buf + " <===");
    }

    public WKTParseState linestringToken(int token) throws ParseException {
        if (token == 40) {
            if (this.state == 0) {
                this.coord = new Coord();
                this.state = 4;
                return this;
            }
            throw new ParseException("Misplaced open: " + this.buf + " <===");
        }
        if (token == 41) {
            if (this.state == 20) {
                if (this.type.equals((Object)WKBGeometryType.BROKEN_MULTIPOINT)) {
                    return this.convertBrokenToMultiPoint();
                }
                if (this.linestring == null) {
                    throw new ParseException("Linestring must have at least 2 coordinates: " + this.buf + " <===");
                }
                this.state = 22;
                this.linestring.add(this.coord);
                this.coord = null;
                if (this.parent == null) {
                    return this;
                }
                return this.parent;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        if (token == 44) {
            if (this.state == 20) {
                if (this.linestring == null) {
                    this.linestring = new ArrayList<Coord>();
                }
                this.linestring.add(this.coord);
                this.coord = new Coord();
                this.state = 4;
                return this;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        throw new ParseException("Misplaced token: " + this.buf + " <===");
    }

    public WKTParseState polygonToken(int token) throws ParseException {
        if (token == 40) {
            if (this.state == 0) {
                this.state = 3;
                return this;
            }
            if (this.state == 3) {
                this.coord = new Coord();
                this.state = 4;
                return this;
            }
            throw new ParseException("Misplaced open: " + this.buf + " <===");
        }
        if (token == 41) {
            if (this.state == 20) {
                if (this.linestring == null) {
                    this.linestring = new ArrayList<Coord>();
                }
                this.linestring.add(this.coord);
                this.coord = null;
                this.state = 21;
                return this;
            }
            if (this.state == 21) {
                if (this.linestrings == null) {
                    this.linestrings = new ArrayList<List<Coord>>();
                }
                this.linestrings.add(this.linestring);
                this.linestring = null;
                this.state = 22;
                if (this.parent == null) {
                    return this;
                }
                return this.parent;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        if (token == 44) {
            if (this.state == 20) {
                if (this.linestring == null) {
                    this.linestring = new ArrayList<Coord>();
                }
                this.linestring.add(this.coord);
                this.coord = new Coord();
                this.state = 4;
                return this;
            }
            if (this.state == 21) {
                if (this.linestrings == null) {
                    this.linestrings = new ArrayList<List<Coord>>();
                }
                this.linestrings.add(this.linestring);
                this.linestring = null;
                this.state = 3;
                return this;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        throw new ParseException("Misplaced token: " + this.buf + " <===");
    }

    public WKTParseState multiToken(int token) throws ParseException {
        if (token == 40) {
            if (this.state == 0) {
                this.state = 1;
                WKTParseState child = new WKTParseState();
                child.setType(this.type.getComponentType());
                child.setBuf(this.buf);
                this.addChild(child);
                return child;
            }
            throw new ParseException("Misplaced open: " + this.buf + " <===");
        }
        if (token == 41) {
            if (this.state == 1) {
                this.state = 22;
                if (this.parent == null) {
                    return this;
                }
                return this.parent;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        if (token == 44) {
            if (this.state == 1) {
                WKTParseState child = new WKTParseState();
                child.setType(this.type.getComponentType());
                child.setBuf(this.buf);
                this.addChild(child);
                return child;
            }
            throw new ParseException("Misplaced ,: " + this.buf + " <===");
        }
        throw new ParseException("Misplaced token: " + this.buf + " <===");
    }

    public WKTParseState collectionToken(int token) throws ParseException {
        if (token == 40) {
            if (this.state == 0) {
                this.state = 2;
                return this;
            }
            throw new ParseException("Misplaced open: " + this.buf + " <===");
        }
        if (token == 41) {
            if (this.state == 25) {
                this.state = 22;
                if (this.parent == null) {
                    return this;
                }
                return this.parent;
            }
            throw new ParseException("Misplaced close: " + this.buf + " <===");
        }
        if (token == 44) {
            if (this.state == 25) {
                this.state = 2;
                return this;
            }
            throw new ParseException("Misplaced ,: " + this.buf + " <===");
        }
        throw new ParseException("Misplaced token: " + this.buf + " <===");
    }

    public WKTParseState setOrd(double ord) throws ParseException {
        if (this.state == 4) {
            this.coord.x = ord;
            this.state = 5;
            return this;
        }
        if (this.state == 5) {
            this.coord.y = ord;
            this.state = 20;
            return this;
        }
        if (this.state == 0 && this.parent != null && this.parent.type.equals((Object)WKBGeometryType.MULTIPOINT) && this.parent.children.size() == 1) {
            this.parent.type = WKBGeometryType.BROKEN_MULTIPOINT;
            this.parent.children.clear();
            this.parent.coord = new Coord();
            this.parent.coord.x = ord;
            this.parent.state = 5;
            return this.parent;
        }
        throw new ParseException("Number not expected here: " + this.buf + " <===");
    }

    private WKTParseState convertBrokenToMultiPoint() {
        this.type = WKBGeometryType.MULTIPOINT;
        if (this.linestring == null) {
            this.linestring = new ArrayList<Coord>();
        }
        this.state = 22;
        this.linestring.add(this.coord);
        this.coord = null;
        for (Coord coord : this.linestring) {
            WKTParseState child = new WKTParseState();
            child.setType(this.type.getComponentType());
            child.setCoord(coord);
            child.setState(22);
            child.setBuf(this.buf);
            this.addChild(child);
        }
        this.linestring = null;
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    public WKBGeometryType getType() {
        return this.type;
    }

    public void setType(WKBGeometryType type) {
        this.type = type;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Coord getCoord() {
        return this.coord;
    }

    public void setCoord(Coord coord) {
        this.coord = coord;
    }

    public List<Coord> getLinestring() {
        return this.linestring;
    }

    public void setLinestring(List<Coord> linestring) {
        this.linestring = linestring;
    }

    public List<List<Coord>> getLinestrings() {
        return this.linestrings;
    }

    public void setLinestrings(List<List<Coord>> linestrings) {
        this.linestrings = linestrings;
    }

    public WKTParseState getParent() {
        return this.parent;
    }

    public void setParent(WKTParseState parent) {
        this.parent = parent;
    }

    public void setBuf(StringBuilder buf) {
        this.buf = buf;
    }

    public byte[] getIntBuf() {
        return this.intBuf;
    }

    public byte[] getLongBuf() {
        return this.longBuf;
    }

    public List<WKTParseState> getChildren() {
        return this.children;
    }

    public void addChild(WKTParseState child) {
        child.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<WKTParseState>();
        }
        this.children.add(child);
    }

    public static class Coord {
        public double x;
        public double y;
    }
}

